/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.List;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneStandardRangePredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

class LuceneNumericRangePredicateBuilder<F, E extends Number>
extends AbstractLuceneStandardRangePredicateBuilder<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
    LuceneNumericRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, AbstractLuceneNumericFieldCodec<F, E> codec) {
        super(searchContext, absoluteFieldPath, nestedPathHierarchy, converter, rawConverter, converterChecker, codec);
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        LuceneNumericDomain domain = ((AbstractLuceneNumericFieldCodec)this.codec).getDomain();
        return domain.createRangeQuery(this.absoluteFieldPath, LuceneNumericRangePredicateBuilder.getLowerValue(domain, this.range.lowerBoundValue(), this.range.lowerBoundInclusion()), LuceneNumericRangePredicateBuilder.getUpperValue(domain, this.range.upperBoundValue(), this.range.upperBoundInclusion()));
    }

    private static <E extends Number> E getLowerValue(LuceneNumericDomain<E> domain, Optional<E> boundValueOptional, RangeBoundInclusion inclusion) {
        if (!boundValueOptional.isPresent()) {
            return domain.getMinValue();
        }
        Number boundValue = (Number)boundValueOptional.get();
        return (E)(RangeBoundInclusion.EXCLUDED.equals((Object)inclusion) ? (Number)domain.getNextValue(boundValue) : (Number)boundValue);
    }

    private static <E extends Number> E getUpperValue(LuceneNumericDomain<E> domain, Optional<E> boundValueOptional, RangeBoundInclusion inclusion) {
        if (!boundValueOptional.isPresent()) {
            return domain.getMaxValue();
        }
        Number boundValue = (Number)boundValueOptional.get();
        return (E)(RangeBoundInclusion.EXCLUDED.equals((Object)inclusion) ? (Number)domain.getPreviousValue(boundValue) : (Number)boundValue);
    }
}

