/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsCompositePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public class LuceneObjectPredicateBuilderFactoryImpl
implements LuceneObjectPredicateBuilderFactory {
    private final String absoluteFieldPath;
    private final List<String> nestedPathHierarchy;
    private final Map<String, LuceneFieldPredicateBuilderFactory> leafFields = new HashMap<String, LuceneFieldPredicateBuilderFactory>();

    public LuceneObjectPredicateBuilderFactoryImpl(LuceneIndexSchemaObjectFieldNode objectNode) {
        this.absoluteFieldPath = objectNode.absolutePath();
        this.nestedPathHierarchy = objectNode.getNestedPathHierarchy();
        this.addLeafFields(objectNode);
    }

    @Override
    public boolean isCompatibleWith(LuceneObjectPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        LuceneObjectPredicateBuilderFactoryImpl casted = (LuceneObjectPredicateBuilderFactoryImpl)other;
        Set<String> leafFieldPaths = this.leafFields.keySet();
        if (!leafFieldPaths.equals(casted.leafFields.keySet())) {
            return false;
        }
        for (String leafFieldPath : leafFieldPaths) {
            if (this.leafFields.get(leafFieldPath).hasCompatibleCodec(casted.leafFields.get(leafFieldPath))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExistsPredicateBuilder<LuceneSearchPredicateBuilder> createExistsPredicateBuilder() {
        LuceneExistsCompositePredicateBuilder objectPredicateBuilder = new LuceneExistsCompositePredicateBuilder(this.absoluteFieldPath, this.nestedPathHierarchy);
        for (Map.Entry<String, LuceneFieldPredicateBuilderFactory> entry : this.leafFields.entrySet()) {
            ExistsPredicateBuilder<LuceneSearchPredicateBuilder> existsPredicateBuilder = entry.getValue().createExistsPredicateBuilder(entry.getKey(), this.nestedPathHierarchy);
            objectPredicateBuilder.addChild((SearchPredicateBuilder<LuceneSearchPredicateBuilder>)existsPredicateBuilder);
        }
        return objectPredicateBuilder;
    }

    private void addLeafFields(LuceneIndexSchemaObjectFieldNode objectNode) {
        for (AbstractLuceneIndexSchemaFieldNode abstractLuceneIndexSchemaFieldNode : objectNode.staticChildren()) {
            if (abstractLuceneIndexSchemaFieldNode.isObjectField() && !abstractLuceneIndexSchemaFieldNode.toObjectField().type().nested()) {
                this.addLeafFields(abstractLuceneIndexSchemaFieldNode.toObjectField());
                continue;
            }
            if (!abstractLuceneIndexSchemaFieldNode.isValueField()) continue;
            this.leafFields.put(abstractLuceneIndexSchemaFieldNode.absolutePath(), ((LuceneIndexSchemaFieldNode)abstractLuceneIndexSchemaFieldNode).type().getPredicateBuilderFactory());
        }
    }
}

