/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneDocumentValueSortBuilder;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneStandardFieldSortBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
extends AbstractLuceneDocumentValueSortBuilder
implements FieldSortBuilder<LuceneSearchSortBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchContext searchContext;
    protected final DslConverter<?, ? extends F> converter;
    private final DslConverter<F, ? extends F> rawConverter;
    private final LuceneCompatibilityChecker converterChecker;
    protected final C codec;
    private final Object sortMissingValueFirstPlaceholder;
    private final Object sortMissingValueLastPlaceholder;
    protected Object missingValue = SortMissingValue.MISSING_LAST;

    protected AbstractLuceneStandardFieldSortBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, String nestedDocumentPath, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, C codec, Object sortMissingValueFirstPlaceholder, Object sortMissingValueLastPlaceholder) {
        super(absoluteFieldPath, nestedDocumentPath);
        this.searchContext = searchContext;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
        this.sortMissingValueFirstPlaceholder = sortMissingValueFirstPlaceholder;
        this.sortMissingValueLastPlaceholder = sortMissingValueLastPlaceholder;
    }

    public void missingFirst() {
        this.missingValue = SortMissingValue.MISSING_FIRST;
    }

    public void missingLast() {
        this.missingValue = SortMissingValue.MISSING_LAST;
    }

    public void missingAs(Object value, ValueConvert convert) {
        DslConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(convert);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.missingValue = this.encodeMissingAs(converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, this.getEventContext());
        }
    }

    protected Object encodeMissingAs(F converted) {
        return this.codec.encode(converted);
    }

    protected Object getEffectiveMissingValue(Object missingValue, SortOrder order) {
        Object effectiveMissingValue = missingValue == SortMissingValue.MISSING_FIRST ? (order == SortOrder.DESC ? this.sortMissingValueLastPlaceholder : this.sortMissingValueFirstPlaceholder) : (missingValue == SortMissingValue.MISSING_LAST ? (order == SortOrder.DESC ? this.sortMissingValueFirstPlaceholder : this.sortMissingValueLastPlaceholder) : missingValue);
        return effectiveMissingValue;
    }

    private DslConverter<?, ? extends F> getDslToIndexConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawConverter;
            }
        }
        this.converterChecker.failIfNotCompatible();
        return this.converter;
    }
}

