/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.comparator.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.comparators.LongComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesToSingleValuesSource;

public class LongValuesSourceComparator
extends LongComparator {
    private final LongMultiValuesToSingleValuesSource source;

    public LongValuesSourceComparator(int numHits, String field, Long missingValue, boolean reversed, int sortPos, LongMultiValuesToSingleValuesSource source) {
        super(numHits, field, missingValue, reversed, sortPos);
        this.source = source;
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new LongValuesSourceLeafComparator(context);
    }

    private class LongValuesSourceLeafComparator
    extends LongComparator.LongLeafComparator {
        LongValuesSourceLeafComparator(LeafReaderContext context) throws IOException {
            super((LongComparator)LongValuesSourceComparator.this, context);
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return LongValuesSourceComparator.this.source.getRawNumericDocValues(context, null);
        }
    }
}

