/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldTypeContext;
import org.hibernate.search.backend.lucene.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

public class LuceneIndexValueFieldType<F>
implements IndexValueFieldTypeDescriptor,
IndexFieldType<F>,
LuceneSearchValueFieldTypeContext<F> {
    private final Class<F> valueType;
    private final DslConverter<F, F> rawDslConverter;
    private final ProjectionConverter<F, F> rawProjectionConverter;
    private final LuceneFieldCodec<F> codec;
    private final DslConverter<?, F> dslConverter;
    private final ProjectionConverter<F, ?> projectionConverter;
    private final boolean searchable;
    private final boolean sortable;
    private final boolean projectable;
    private final boolean aggregable;
    private final Map<SearchQueryElementTypeKey<?>, LuceneSearchValueFieldQueryElementFactory<?, F>> queryElementFactories;
    private final Analyzer indexingAnalyzerOrNormalizer;
    private final Analyzer searchAnalyzerOrNormalizer;
    private final String analyzerName;
    private final String searchAnalyzerName;
    private final String normalizerName;

    private LuceneIndexValueFieldType(Builder<F> builder) {
        this.valueType = ((Builder)builder).valueType;
        this.rawDslConverter = ((Builder)builder).rawDslConverter;
        this.rawProjectionConverter = ((Builder)builder).rawProjectionConverter;
        this.codec = ((Builder)builder).codec;
        this.dslConverter = ((Builder)builder).dslConverter != null ? ((Builder)builder).dslConverter : this.rawDslConverter;
        this.projectionConverter = ((Builder)builder).projectionConverter != null ? ((Builder)builder).projectionConverter : this.rawProjectionConverter;
        this.searchable = ((Builder)builder).searchable;
        this.sortable = ((Builder)builder).sortable;
        this.projectable = ((Builder)builder).projectable;
        this.aggregable = ((Builder)builder).aggregable;
        this.queryElementFactories = ((Builder)builder).queryElementFactories;
        this.indexingAnalyzerOrNormalizer = builder.indexingAnalyzerOrNormalizer();
        this.searchAnalyzerOrNormalizer = ((Builder)builder).searchAnalyzer != null ? ((Builder)builder).searchAnalyzer : this.indexingAnalyzerOrNormalizer;
        this.analyzerName = ((Builder)builder).analyzerName;
        this.searchAnalyzerName = ((Builder)builder).searchAnalyzerName != null ? ((Builder)builder).searchAnalyzerName : this.analyzerName;
        this.normalizerName = ((Builder)builder).normalizerName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[codec=" + this.codec + ", analyzerName=" + this.analyzerName + ", searchAnalyzerName=" + this.searchAnalyzerName + ", normalizerName=" + this.normalizerName + ", capabilities=" + this.queryElementFactories.keySet() + "]";
    }

    public Class<F> valueClass() {
        return this.valueType;
    }

    public LuceneFieldCodec<F> codec() {
        return this.codec;
    }

    public boolean searchable() {
        return this.searchable;
    }

    public boolean sortable() {
        return this.sortable;
    }

    public boolean projectable() {
        return this.projectable;
    }

    public boolean aggregable() {
        return this.aggregable;
    }

    public Class<?> dslArgumentClass() {
        return this.dslConverter.valueType();
    }

    @Override
    public DslConverter<?, F> dslConverter() {
        return this.dslConverter;
    }

    @Override
    public DslConverter<F, F> rawDslConverter() {
        return this.rawDslConverter;
    }

    public Class<?> projectedValueClass() {
        return this.projectionConverter.valueType();
    }

    @Override
    public ProjectionConverter<F, ?> projectionConverter() {
        return this.projectionConverter;
    }

    @Override
    public ProjectionConverter<F, F> rawProjectionConverter() {
        return this.rawProjectionConverter;
    }

    public Optional<String> analyzerName() {
        return Optional.ofNullable(this.analyzerName);
    }

    public Optional<String> normalizerName() {
        return Optional.ofNullable(this.normalizerName);
    }

    @Override
    public Optional<String> searchAnalyzerName() {
        return Optional.ofNullable(this.searchAnalyzerName);
    }

    @Override
    public <T> LuceneSearchValueFieldQueryElementFactory<T, F> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        return this.queryElementFactories.get(key);
    }

    public Analyzer indexingAnalyzerOrNormalizer() {
        return this.indexingAnalyzerOrNormalizer;
    }

    @Override
    public Analyzer searchAnalyzerOrNormalizer() {
        return this.searchAnalyzerOrNormalizer;
    }

    public static class Builder<F> {
        private final Class<F> valueType;
        private final DslConverter<F, F> rawDslConverter;
        private final ProjectionConverter<F, F> rawProjectionConverter;
        private LuceneFieldCodec<F> codec;
        private DslConverter<?, F> dslConverter;
        private ProjectionConverter<F, ?> projectionConverter;
        private boolean searchable;
        private boolean sortable;
        private boolean projectable;
        private boolean aggregable;
        private final Map<SearchQueryElementTypeKey<?>, LuceneSearchValueFieldQueryElementFactory<?, F>> queryElementFactories = new HashMap();
        private Analyzer analyzer;
        private String analyzerName;
        private Analyzer searchAnalyzer;
        private String searchAnalyzerName;
        private Analyzer normalizer;
        private String normalizerName;

        public Builder(Class<F> valueType) {
            this.valueType = valueType;
            this.rawDslConverter = new DslConverter(valueType, (ToDocumentFieldValueConverter)new PassThroughToDocumentFieldValueConverter());
            this.rawProjectionConverter = new ProjectionConverter(valueType, (FromDocumentFieldValueConverter)new PassThroughFromDocumentFieldValueConverter());
        }

        public void codec(LuceneFieldCodec<F> codec) {
            this.codec = codec;
        }

        public <V> void dslConverter(Class<V> valueType, ToDocumentFieldValueConverter<V, ? extends F> toIndexConverter) {
            this.dslConverter = new DslConverter(valueType, toIndexConverter);
        }

        public <V> void projectionConverter(Class<V> valueType, FromDocumentFieldValueConverter<? super F, V> fromIndexConverter) {
            this.projectionConverter = new ProjectionConverter(valueType, fromIndexConverter);
        }

        public void searchable(boolean searchable) {
            this.searchable = searchable;
        }

        public void sortable(boolean sortable) {
            this.sortable = sortable;
        }

        public void projectable(boolean projectable) {
            this.projectable = projectable;
        }

        public void aggregable(boolean aggregable) {
            this.aggregable = aggregable;
        }

        public <T> void queryElementFactory(SearchQueryElementTypeKey<T> key, LuceneSearchValueFieldQueryElementFactory<T, F> factory) {
            this.queryElementFactories.put(key, factory);
        }

        public void analyzer(String analyzerName, Analyzer analyzer) {
            this.analyzerName = analyzerName;
            this.analyzer = analyzer;
        }

        public void searchAnalyzer(String searchAnalyzerName, Analyzer searchAnalyzer) {
            this.searchAnalyzerName = searchAnalyzerName;
            this.searchAnalyzer = searchAnalyzer;
        }

        public void normalizer(String normalizerName, Analyzer normalizer) {
            this.normalizerName = normalizerName;
            this.normalizer = normalizer;
        }

        public Analyzer indexingAnalyzerOrNormalizer() {
            return this.analyzer != null ? this.analyzer : this.normalizer;
        }

        public LuceneIndexValueFieldType<F> build() {
            return new LuceneIndexValueFieldType(this);
        }
    }
}

