/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface LuceneSearchSort
extends SearchSort {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public void toSortFields(LuceneSearchSortCollector var1);

    public static LuceneSearchSort from(LuceneSearchContext searchContext, SearchSort sort) {
        if (!(sort instanceof LuceneSearchSort)) {
            throw log.cannotMixLuceneSearchSortWithOtherSorts(sort);
        }
        LuceneSearchSort casted = (LuceneSearchSort)sort;
        if (!searchContext.indexes().indexNames().equals(casted.indexNames())) {
            throw log.sortDefinedOnDifferentIndexes(sort, casted.indexNames(), searchContext.indexes().indexNames());
        }
        return casted;
    }
}

