/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaRootNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldTemplate;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactory;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeFactoryImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexSchemaRootNodeBuilder
extends AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaRootNodeBuilder,
IndexSchemaBuildContext {
    private final EventContext indexEventContext;
    private final String mappedTypeName;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private ToDocumentIdentifierValueConverter<?> idDslConverter;

    public LuceneIndexSchemaRootNodeBuilder(EventContext indexEventContext, String mappedTypeName, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.indexEventContext = indexEventContext;
        this.mappedTypeName = mappedTypeName;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public EventContext eventContext() {
        return this.getIndexEventContext().append(EventContexts.indexSchemaRoot());
    }

    public LuceneIndexFieldTypeFactory createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return new LuceneIndexFieldTypeFactoryImpl(this.indexEventContext, this.analysisDefinitionRegistry, defaultsProvider);
    }

    public void explicitRouting() {
    }

    public void idDslConverter(ToDocumentIdentifierValueConverter<?> idDslConverter) {
        this.idDslConverter = idDslConverter;
    }

    @Override
    public LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this;
    }

    public LuceneIndexModel build(String indexName) {
        final HashMap<String, AbstractLuceneIndexSchemaFieldNode> staticFields = new HashMap<String, AbstractLuceneIndexSchemaFieldNode>();
        final ArrayList fieldTemplates = new ArrayList();
        final boolean[] hasNestedDocument = new boolean[1];
        LuceneIndexSchemaNodeCollector collector = new LuceneIndexSchemaNodeCollector(){

            @Override
            public void collect(String absoluteFieldPath, LuceneIndexSchemaValueFieldNode<?> node) {
                staticFields.put(absoluteFieldPath, node);
            }

            @Override
            public void collect(String absolutePath, LuceneIndexSchemaObjectFieldNode node) {
                staticFields.put(absolutePath, node);
                if (LuceneIndexSchemaRootNodeBuilder.this.isNested(node.structure())) {
                    hasNestedDocument[0] = true;
                }
            }

            @Override
            public void collect(LuceneIndexSchemaObjectFieldTemplate template) {
                fieldTemplates.add(template);
                if (LuceneIndexSchemaRootNodeBuilder.this.isNested(template.structure())) {
                    hasNestedDocument[0] = true;
                }
            }

            @Override
            public void collect(LuceneIndexSchemaValueFieldTemplate template) {
                fieldTemplates.add(template);
            }
        };
        TreeMap<String, AbstractLuceneIndexSchemaFieldNode> staticChildrenByName = new TreeMap<String, AbstractLuceneIndexSchemaFieldNode>();
        LuceneIndexSchemaRootNode rootNode = new LuceneIndexSchemaRootNode(staticChildrenByName);
        this.contributeChildren(rootNode, collector, staticChildrenByName);
        return new LuceneIndexModel(indexName, this.mappedTypeName, (ToDocumentIdentifierValueConverter<?>)(this.idDslConverter == null ? new StringToDocumentIdentifierValueConverter() : this.idDslConverter), rootNode, (Map<String, AbstractLuceneIndexSchemaFieldNode>)staticFields, fieldTemplates, hasNestedDocument[0]);
    }

    @Override
    String getAbsolutePath() {
        return null;
    }

    EventContext getIndexEventContext() {
        return this.indexEventContext;
    }

    private boolean isNested(ObjectStructure structure) {
        switch (structure) {
            case NESTED: {
                return true;
            }
        }
        return false;
    }
}

