/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.engine.common.timing.spi.Deadline;

public class TimeoutCountCollector
extends SimpleCollector {
    private final Deadline deadline;
    private int totalHits;

    public TimeoutCountCollector(Deadline deadline) {
        this.deadline = deadline;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public void collect(int doc) {
        if (this.totalHits % 256 == 0) {
            this.deadline.remainingTimeMillis();
        }
        ++this.totalHits;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

