/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.util.ThreadInterruptedException;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class HibernateSearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final String contextDescription;
    private final ThreadProvider threadProvider;
    private final FailureHandler failureHandler;

    HibernateSearchConcurrentMergeScheduler(String indexName, String contextDescription, ThreadProvider threadProvider, FailureHandler failureHandler) {
        this.indexName = indexName;
        this.contextDescription = contextDescription;
        this.threadProvider = threadProvider;
        this.failureHandler = failureHandler;
    }

    protected void handleMergeException(Throwable t) {
        try {
            super.handleMergeException(t);
        }
        catch (ThreadInterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            FailureContext.Builder contextBuilder = FailureContext.builder();
            contextBuilder.throwable((Throwable)ex);
            contextBuilder.failingOperation((Object)log.indexMergeOperation(this.indexName));
            this.failureHandler.handle(contextBuilder.build());
        }
    }

    protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) {
        ConcurrentMergeScheduler.MergeThread thread = new ConcurrentMergeScheduler.MergeThread((ConcurrentMergeScheduler)this, mergeSource, merge);
        thread.setDaemon(true);
        thread.setName(this.threadProvider.createThreadName(this.contextDescription + " - Lucene Merge Thread", this.mergeThreadCount++));
        return thread;
    }
}

