/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneMultiIndexSearchObjectFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneMultiIndexSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchObjectFieldContext;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneScopeSearchIndexesContext
implements LuceneSearchIndexesContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final StringToDocumentIdentifierValueConverter RAW_ID_CONVERTER = new StringToDocumentIdentifierValueConverter();
    private final Map<String, LuceneScopeIndexManagerContext> mappedTypeNameToIndex = new LinkedHashMap<String, LuceneScopeIndexManagerContext>();
    private final Set<String> indexNames = new LinkedHashSet<String>();

    public LuceneScopeSearchIndexesContext(Set<? extends LuceneScopeIndexManagerContext> indexManagerContexts) {
        for (LuceneScopeIndexManagerContext luceneScopeIndexManagerContext : indexManagerContexts) {
            this.mappedTypeNameToIndex.put(luceneScopeIndexManagerContext.model().mappedTypeName(), luceneScopeIndexManagerContext);
            this.indexNames.add(luceneScopeIndexManagerContext.model().hibernateSearchName());
        }
    }

    public Collection<LuceneScopeIndexManagerContext> elements() {
        return this.mappedTypeNameToIndex.values();
    }

    @Override
    public Map<String, ? extends LuceneSearchIndexContext> mappedTypeNameToIndex() {
        return this.mappedTypeNameToIndex;
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public ToDocumentIdentifierValueConverter<?> idDslConverter(ValueConvert valueConvert) {
        if (ValueConvert.NO.equals((Object)valueConvert)) {
            return RAW_ID_CONVERTER;
        }
        ToDocumentIdentifierValueConverter<?> converter = null;
        for (LuceneScopeIndexManagerContext index : this.elements()) {
            ToDocumentIdentifierValueConverter<?> converterForIndex = index.model().idDslConverter();
            if (converter == null) {
                converter = converterForIndex;
                continue;
            }
            if (converter.isCompatibleWith(converterForIndex)) continue;
            throw log.inconsistentConfigurationForIdentifierForSearch(converter, converterForIndex, this.indexesEventContext());
        }
        return converter;
    }

    @Override
    public LuceneSearchFieldContext field(String absoluteFieldPath) {
        LuceneSearchFieldContext resultOrNull = this.elements().size() == 1 ? this.elements().iterator().next().model().fieldOrNull(absoluteFieldPath) : this.createMultiIndexFieldContext(absoluteFieldPath);
        if (resultOrNull == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesEventContext());
        }
        return resultOrNull;
    }

    @Override
    public boolean hasNestedDocuments() {
        for (LuceneScopeIndexManagerContext element : this.elements()) {
            if (!element.model().hasNestedDocuments()) continue;
            return true;
        }
        return false;
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }

    private LuceneSearchFieldContext createMultiIndexFieldContext(String absoluteFieldPath) {
        ArrayList<LuceneSearchObjectFieldContext> fieldForEachIndex = new ArrayList<LuceneSearchObjectFieldContext>();
        LuceneScopeIndexManagerContext indexOfFirstField = null;
        AbstractLuceneIndexSchemaFieldNode firstField = null;
        for (LuceneScopeIndexManagerContext index : this.elements()) {
            LuceneIndexModel indexModel = index.model();
            AbstractLuceneIndexSchemaFieldNode fieldForCurrentIndex = indexModel.fieldOrNull(absoluteFieldPath);
            if (fieldForCurrentIndex == null) continue;
            if (firstField == null) {
                indexOfFirstField = index;
                firstField = fieldForCurrentIndex;
            } else if (firstField.isObjectField() != fieldForCurrentIndex.isObjectField()) {
                SearchException cause = log.conflictingFieldModel();
                throw log.inconsistentConfigurationForFieldForSearch(absoluteFieldPath, cause.getMessage(), EventContexts.fromIndexNames((String[])new String[]{indexOfFirstField.model().hibernateSearchName(), index.model().hibernateSearchName()}), cause);
            }
            fieldForEachIndex.add((LuceneSearchObjectFieldContext)((Object)fieldForCurrentIndex));
        }
        if (fieldForEachIndex.isEmpty()) {
            return null;
        }
        if (firstField.isObjectField()) {
            return new LuceneMultiIndexSearchObjectFieldContext(this, absoluteFieldPath, fieldForEachIndex);
        }
        return new LuceneMultiIndexSearchValueFieldContext(this.indexNames, absoluteFieldPath, fieldForEachIndex);
    }
}

