/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.ExplicitDocIdsQuery;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.CollectorSet;
import org.hibernate.search.engine.common.timing.spi.Deadline;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.query.spi.SimpleSearchResultTotal;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.AssertionFailure;

public class LuceneCollectors {
    static final CollectorKey<TotalHitCountCollector> TOTAL_HIT_COUNT_KEY = CollectorKey.create();
    static final CollectorKey<TopDocsCollector<?>> TOP_DOCS_KEY = CollectorKey.create();
    private final IndexReaderMetadataResolver metadataResolver;
    private final IndexSearcher indexSearcher;
    private final Query rewrittenLuceneQuery;
    private final boolean requireFieldDocRescoring;
    private final Integer scoreSortFieldIndexForRescoring;
    private final CollectorSet collectorsForAllMatchingDocs;
    private final Set<CollectorFactory<?>> collectorsForTopDocsFactories;
    private CollectorSet collectorsForTopDocs;
    private final TimeoutManager timeoutManager;
    private SearchResultTotal resultTotal;
    private TopDocs topDocs = null;

    LuceneCollectors(IndexReaderMetadataResolver metadataResolver, IndexSearcher indexSearcher, Query rewrittenLuceneQuery, boolean requireFieldDocRescoring, Integer scoreSortFieldIndexForRescoring, CollectorSet collectorsForAllMatchingDocs, Set<CollectorFactory<?>> collectorsForTopDocsFactories, TimeoutManager timeoutManager) {
        this.metadataResolver = metadataResolver;
        this.indexSearcher = indexSearcher;
        this.rewrittenLuceneQuery = rewrittenLuceneQuery;
        this.requireFieldDocRescoring = requireFieldDocRescoring;
        this.scoreSortFieldIndexForRescoring = scoreSortFieldIndexForRescoring;
        this.collectorsForAllMatchingDocs = collectorsForAllMatchingDocs;
        this.collectorsForTopDocsFactories = collectorsForTopDocsFactories;
        this.timeoutManager = timeoutManager;
    }

    public void collectMatchingDocs(int offset, Integer limit) throws IOException {
        if (this.timeoutManager.checkTimedOut()) {
            this.resultTotal = SimpleSearchResultTotal.lowerBound((long)0L);
            return;
        }
        try {
            Collector composed = this.collectorsForAllMatchingDocs.getComposed();
            if (composed != null) {
                this.indexSearcher.search(this.rewrittenLuceneQuery, composed);
            }
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            Deadline deadline = this.timeoutManager.deadlineOrNull();
            if (deadline == null) {
                throw new AssertionFailure("Timeout reached, but no timeout was defined", (Throwable)e);
            }
            deadline.forceTimeout((Exception)((Object)e));
        }
        this.processCollectedMatchingDocs(offset, limit);
    }

    private void processCollectedMatchingDocs(int offset, Integer limit) throws IOException {
        boolean exact;
        if (this.rewrittenLuceneQuery instanceof MatchAllDocsQuery) {
            this.resultTotal = SimpleSearchResultTotal.exact((long)this.indexSearcher.getIndexReader().numDocs());
        } else {
            TotalHitCountCollector totalHitCountCollector = this.collectorsForAllMatchingDocs.get(TOTAL_HIT_COUNT_KEY);
            if (totalHitCountCollector != null) {
                exact = !this.timeoutManager.isTimedOut();
                this.resultTotal = SimpleSearchResultTotal.of((long)totalHitCountCollector.getTotalHits(), (boolean)exact);
            }
        }
        TopDocsCollector<?> topDocsCollector = this.collectorsForAllMatchingDocs.get(TOP_DOCS_KEY);
        if (topDocsCollector == null) {
            if (this.resultTotal == null) {
                this.resultTotal = SimpleSearchResultTotal.lowerBound((long)0L);
            }
            return;
        }
        this.extractTopDocs(topDocsCollector, offset, limit);
        if (this.resultTotal == null) {
            exact = TotalHits.Relation.EQUAL_TO.equals((Object)this.topDocs.totalHits.relation) && !this.timeoutManager.isTimedOut();
            this.resultTotal = SimpleSearchResultTotal.of((long)this.topDocs.totalHits.value, (boolean)exact);
        } else if (this.resultTotal.isHitCountExact()) {
            this.topDocs.totalHits = new TotalHits(this.resultTotal.hitCount(), TotalHits.Relation.EQUAL_TO);
        }
        if (this.requireFieldDocRescoring) {
            this.handleRescoring();
        }
    }

    public CollectorSet getCollectorsForAllMatchingDocs() {
        return this.collectorsForAllMatchingDocs;
    }

    public void collectTopDocsData(int startInclusive, int endExclusive) throws IOException {
        if (this.collectorsForTopDocsFactories.isEmpty() || this.topDocs == null) {
            this.collectorsForTopDocs = null;
            return;
        }
        try {
            ScoreDoc[] scoreDocs = this.topDocs.scoreDocs;
            ExplicitDocIdsQuery topDocsQuery = new ExplicitDocIdsQuery(scoreDocs, startInclusive, endExclusive);
            this.collectorsForTopDocs = this.buildTopdDocsDataCollectors(topDocsQuery);
            this.indexSearcher.search((Query)topDocsQuery, this.collectorsForTopDocs.getComposed());
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            Deadline deadline = this.timeoutManager.deadlineOrNull();
            if (deadline == null) {
                throw new AssertionFailure("Timeout reached, but no timeout was defined", (Throwable)e);
            }
            deadline.forceTimeout((Exception)((Object)e));
        }
    }

    public CollectorSet getCollectorsForTopDocs() {
        return this.collectorsForTopDocs;
    }

    public SearchResultTotal getResultTotal() {
        return this.resultTotal;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    private void extractTopDocs(TopDocsCollector<?> topDocsCollector, int offset, Integer limit) {
        if (offset >= topDocsCollector.getTotalHits()) {
            TopDocs firstTopDoc = topDocsCollector.topDocs(0, 1);
            this.topDocs = firstTopDoc instanceof TopFieldDocs ? new TopFieldDocs(firstTopDoc.totalHits, (ScoreDoc[])new FieldDoc[0], ((TopFieldDocs)firstTopDoc).fields) : new TopDocs(firstTopDoc.totalHits, new ScoreDoc[0]);
            return;
        }
        this.topDocs = limit == null ? topDocsCollector.topDocs(offset) : topDocsCollector.topDocs(offset, limit.intValue());
    }

    private void handleRescoring() throws IOException {
        if (this.scoreSortFieldIndexForRescoring != null) {
            for (ScoreDoc scoreDoc : this.topDocs.scoreDocs) {
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                fieldDoc.score = ((Float)fieldDoc.fields[this.scoreSortFieldIndexForRescoring]).floatValue();
            }
        } else {
            TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)this.indexSearcher, (Query)this.rewrittenLuceneQuery);
        }
    }

    private CollectorSet buildTopdDocsDataCollectors(Query topDocsQuery) throws IOException {
        CollectorExecutionContext executionContext = new CollectorExecutionContext(this.metadataResolver, this.indexSearcher, topDocsQuery, this.topDocs.scoreDocs.length);
        CollectorSet.Builder collectorForTopDocsBuilder = new CollectorSet.Builder(executionContext, this.timeoutManager);
        collectorForTopDocsBuilder.addAll(this.collectorsForTopDocsFactories);
        return collectorForTopDocsBuilder.build();
    }
}

