/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneYearMonthFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneLongDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneLocalDateFieldCodec
extends AbstractLuceneNumericFieldCodec<LocalDate, Long> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(LuceneYearMonthFieldCodec.FORMATTER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneLocalDateFieldCodec(Indexing indexing, DocValues docValues, Storage storage, LocalDate indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, LocalDate value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public LocalDate decode(IndexableField field) {
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return LocalDate.parse(value, FORMATTER);
    }

    @Override
    public Long encode(LocalDate value) {
        return value == null ? null : Long.valueOf(value.toEpochDay());
    }

    @Override
    public LocalDate decode(Long encoded) {
        return LocalDate.ofEpochDay(encoded);
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneLongDomain.get();
    }
}

