/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneReversibleSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractLuceneDocumentValueSort
extends AbstractLuceneReversibleSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final SortField sortField;
    protected final LuceneFieldComparatorSource nestedFieldSort;

    protected AbstractLuceneDocumentValueSort(AbstractBuilder builder) {
        super(builder);
        LuceneFieldComparatorSource fieldComparatorSource = builder.toFieldComparatorSource();
        this.sortField = new SortField(builder.absoluteFieldPath, (FieldComparatorSource)fieldComparatorSource, this.order == SortOrder.DESC);
        this.nestedFieldSort = builder.nestedDocumentPath != null ? fieldComparatorSource : null;
    }

    @Override
    public void toSortFields(LuceneSearchSortCollector collector) {
        collector.collectSortField(this.sortField, this.nestedFieldSort);
    }

    public static abstract class AbstractBuilder
    extends AbstractLuceneReversibleSort.AbstractBuilder {
        protected final String absoluteFieldPath;
        protected final String nestedDocumentPath;
        private SortMode mode;
        protected Query nestedFilter;

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            this(scope, field.absolutePath(), field.nestedDocumentPath());
        }

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, String absoluteFieldPath, String nestedDocumentPath) {
            super(scope);
            this.absoluteFieldPath = absoluteFieldPath;
            this.nestedDocumentPath = nestedDocumentPath;
        }

        public void mode(SortMode mode) {
            if (this.nestedDocumentPath != null && SortMode.MEDIAN.equals((Object)mode)) {
                throw log.invalidSortModeAcrossNested(mode, this.getEventContext());
            }
            this.mode = mode;
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedDocumentPath == null) {
                throw log.cannotFilterSortOnRootDocumentField(this.absoluteFieldPath, this.getEventContext());
            }
            LuceneSearchPredicate luceneFilter = LuceneSearchPredicate.from(this.scope, filter);
            luceneFilter.checkNestableWithin(this.nestedDocumentPath);
            PredicateRequestContext filterContext = new PredicateRequestContext(this.nestedDocumentPath);
            this.nestedFilter = luceneFilter.toQuery(filterContext);
        }

        protected abstract LuceneFieldComparatorSource toFieldComparatorSource();

        protected final MultiValueMode getMultiValueMode() {
            MultiValueMode multiValueMode;
            if (this.mode == null) {
                multiValueMode = this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
            } else {
                switch (this.mode) {
                    case MIN: {
                        multiValueMode = MultiValueMode.MIN;
                        break;
                    }
                    case MAX: {
                        multiValueMode = MultiValueMode.MAX;
                        break;
                    }
                    case AVG: {
                        multiValueMode = MultiValueMode.AVG;
                        break;
                    }
                    case SUM: {
                        multiValueMode = MultiValueMode.SUM;
                        break;
                    }
                    case MEDIAN: {
                        multiValueMode = MultiValueMode.MEDIAN;
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unexpected sort mode: " + this.mode);
                    }
                }
            }
            return multiValueMode;
        }

        protected Query getNestedFilter() {
            return this.nestedFilter;
        }

        protected final EventContext getEventContext() {
            return EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath);
        }
    }
}

