/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexScopeBuilder;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.impl.ShardHolder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.schema.management.impl.LuceneIndexSchemaManager;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.common.resources.spi.SavedState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexManagerImpl
implements IndexManagerImplementor,
LuceneIndexManager,
LuceneScopeIndexManagerContext {
    private static final SavedState.Key<SavedState> SHARD_HOLDER_KEY = SavedState.key((String)"shard_holder");
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexManagerBackendContext backendContext;
    private final String indexName;
    private final LuceneIndexModel model;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final ShardHolder shardHolder;
    private final LuceneIndexSchemaManager schemaManager;

    LuceneIndexManagerImpl(IndexManagerBackendContext backendContext, String indexName, LuceneIndexModel model, LuceneIndexEntryFactory indexEntryFactory) {
        this.backendContext = backendContext;
        this.indexName = indexName;
        this.model = model;
        this.indexEntryFactory = indexEntryFactory;
        this.shardHolder = new ShardHolder(backendContext, model);
        this.schemaManager = backendContext.createSchemaManager(this.shardHolder);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.indexName + "]";
    }

    public SavedState saveForRestart() {
        return SavedState.builder().put(SHARD_HOLDER_KEY, this.shardHolder.saveForRestart()).build();
    }

    public void preStart(IndexManagerStartContext context, SavedState savedState) {
        this.shardHolder.preStart(context, savedState.get(SHARD_HOLDER_KEY).orElse(SavedState.empty()));
    }

    public void start(IndexManagerStartContext context) {
        this.shardHolder.start(context);
    }

    public CompletableFuture<?> preStop() {
        return this.shardHolder.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(ShardHolder::stop, (Object)this.shardHolder);
            closer.push(LuceneIndexModel::close, (Object)this.model);
        }
    }

    public IndexSchemaManager schemaManager() {
        return this.schemaManager;
    }

    public IndexIndexingPlan createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.backendContext.createIndexingPlan(this.shardHolder, this.indexEntryFactory, sessionContext, commitStrategy, refreshStrategy);
    }

    public IndexIndexer createIndexer(BackendSessionContext sessionContext) {
        return this.backendContext.createIndexer(this.shardHolder, this.indexEntryFactory, sessionContext);
    }

    public IndexWorkspace createWorkspace(BackendMappingContext mappingContext, String tenantId) {
        return this.backendContext.createWorkspace(this.shardHolder, tenantId);
    }

    public IndexScopeBuilder createScopeBuilder(BackendMappingContext mappingContext) {
        return new LuceneIndexScopeBuilder(this.backendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof LuceneIndexScopeBuilder)) {
            throw log.cannotMixLuceneScopeWithOtherType(builder, this, this.backendContext.getEventContext());
        }
        LuceneIndexScopeBuilder luceneBuilder = (LuceneIndexScopeBuilder)builder;
        luceneBuilder.add(this.backendContext, this);
    }

    @Override
    public void openIndexReaders(Set<String> routingKeys, DirectoryReaderCollector readerCollector) throws IOException {
        this.shardHolder.openIndexReaders(routingKeys, readerCollector);
    }

    @Override
    public LuceneIndexModel model() {
        return this.model;
    }

    @Override
    public SearchIndexIdentifierContext identifier() {
        return this.model.identifier();
    }

    public IndexManager toAPI() {
        return this;
    }

    @Override
    public LuceneBackend backend() {
        return this.backendContext.toAPI();
    }

    public IndexDescriptor descriptor() {
        return this.model;
    }

    @Override
    public Analyzer indexingAnalyzer() {
        return this.model.getIndexingAnalyzer();
    }

    @Override
    public Analyzer searchAnalyzer() {
        return this.model.getSearchAnalyzer();
    }

    @Override
    public long computeSizeInBytes() {
        return (Long)Futures.unwrappedExceptionJoin((CompletableFuture)this.computeSizeInBytesAsync());
    }

    public CompletableFuture<Long> computeSizeInBytesAsync() {
        return this.computeSizeInBytesAsync(OperationSubmitter.rejecting());
    }

    public CompletableFuture<Long> computeSizeInBytesAsync(OperationSubmitter operationSubmitter) {
        return this.schemaManager.computeSizeInBytes(operationSubmitter);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, LuceneIndexManager.class, this.getBackendAndIndexEventContext());
    }

    public final List<Shard> getShardsForTests() {
        return this.shardHolder.shardsForTests();
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.backendContext.getEventContext().append(EventContexts.fromIndexName((String)this.indexName));
    }
}

