/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntIntMap;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;

public class TopDocsDataCollectorExecutionContext
extends CollectorExecutionContext {
    private final Query executedQuery;
    private final TopDocs topDocs;
    private final StoredFieldsValuesDelegate storedFieldsValuesDelegate;
    private IntIntMap docIdToScoreDocIndex;

    public TopDocsDataCollectorExecutionContext(IndexReaderMetadataResolver metadataResolver, IndexSearcher indexSearcher, Query executedQuery, TopDocs topDocs, StoredFieldsValuesDelegate.Factory storedFieldsValuesDelegateOrNull) throws IOException {
        super(metadataResolver, indexSearcher, topDocs.scoreDocs.length);
        this.executedQuery = executedQuery;
        this.topDocs = topDocs;
        this.storedFieldsValuesDelegate = storedFieldsValuesDelegateOrNull == null ? null : storedFieldsValuesDelegateOrNull.create(this);
    }

    public Query executedQuery() {
        return this.executedQuery;
    }

    public TopDocs topDocs() {
        return this.topDocs;
    }

    public IntIntMap docIdToScoreDocIndex() {
        ScoreDoc[] scoreDocs = this.topDocs.scoreDocs;
        if (this.docIdToScoreDocIndex == null) {
            this.docIdToScoreDocIndex = new IntIntHashMap();
            for (int i = 0; i < scoreDocs.length; ++i) {
                this.docIdToScoreDocIndex.put(scoreDocs[i].doc, i);
            }
        }
        return this.docIdToScoreDocIndex;
    }

    public StoredFieldsValuesDelegate storedFieldsValuesDelegate() {
        return this.storedFieldsValuesDelegate;
    }
}

