/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.schema.management.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.schema.management.impl.SchemaManagementIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

public class LuceneIndexSchemaManager
implements IndexSchemaManager {
    private final LuceneWorkFactory luceneWorkFactory;
    private final SchemaManagementIndexManagerContext indexManagerContext;

    public LuceneIndexSchemaManager(LuceneWorkFactory luceneWorkFactory, SchemaManagementIndexManagerContext indexManagerContext) {
        this.luceneWorkFactory = luceneWorkFactory;
        this.indexManagerContext = indexManagerContext;
    }

    public CompletableFuture<?> createIfMissing(OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.luceneWorkFactory.createIndexIfMissing(), operationSubmitter);
    }

    public CompletableFuture<?> createOrValidate(ContextualFailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.createIfMissing(operationSubmitter);
    }

    public CompletableFuture<?> createOrUpdate(OperationSubmitter operationSubmitter) {
        return this.createIfMissing(operationSubmitter);
    }

    public CompletableFuture<?> dropIfExisting(OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.luceneWorkFactory.dropIndexIfExisting(), operationSubmitter);
    }

    public CompletableFuture<?> dropAndCreate(OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.luceneWorkFactory.dropIndexIfExisting(), operationSubmitter).thenCompose(ignored -> this.doSubmit(this.luceneWorkFactory.createIndexIfMissing(), operationSubmitter));
    }

    public CompletableFuture<?> validate(ContextualFailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.luceneWorkFactory.validateIndexExists(), operationSubmitter);
    }

    public CompletableFuture<Long> computeSizeInBytes(OperationSubmitter operationSubmitter) {
        IndexManagementWork<Long> computeSizeWork = this.luceneWorkFactory.computeSizeInBytes();
        BinaryOperator add = Math::addExact;
        CompletionStage<Long> totalSizeFuture = CompletableFuture.completedFuture(0L);
        for (LuceneParallelWorkOrchestrator orchestrator : this.indexManagerContext.allManagementOrchestrators()) {
            CompletableFuture<Long> shardSizeFuture = orchestrator.submit(computeSizeWork, operationSubmitter);
            totalSizeFuture = totalSizeFuture.thenCombine(shardSizeFuture, (BiFunction)add);
        }
        return totalSizeFuture;
    }

    private CompletableFuture<?> doSubmit(IndexManagementWork<?> work, OperationSubmitter operationSubmitter) {
        Collection<LuceneParallelWorkOrchestrator> orchestrators = this.indexManagerContext.allManagementOrchestrators();
        CompletableFuture[] futures = new CompletableFuture[orchestrators.size()];
        int i = 0;
        for (LuceneParallelWorkOrchestrator orchestrator : orchestrators) {
            futures[i] = orchestrator.submit(work, operationSubmitter);
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }
}

