/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;

class LuceneCompositeProjection<E, V, A, P>
extends AbstractLuceneProjection<P> {
    private final LuceneSearchProjection<?>[] inners;
    private final ProjectionCompositor<E, V> compositor;
    private final ProjectionAccumulator<E, V, A, P> accumulator;

    public LuceneCompositeProjection(Builder builder, LuceneSearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator<E, V, A, P> accumulator) {
        super(builder.scope);
        this.inners = inners;
        this.compositor = compositor;
        this.accumulator = accumulator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + this.compositor + ", accumulator=" + this.accumulator + "]";
    }

    @Override
    public LuceneSearchProjection.Extractor<?, P> request(ProjectionRequestContext context) {
        LuceneSearchProjection.Extractor[] innerExtractors = new LuceneSearchProjection.Extractor[this.inners.length];
        for (int i = 0; i < this.inners.length; ++i) {
            innerExtractors[i] = this.inners[i].request(context);
        }
        return new CompositeExtractor(innerExtractors);
    }

    static class Builder
    implements CompositeProjectionBuilder {
        private final LuceneSearchIndexScope<?> scope;

        Builder(LuceneSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public <E, V, P> SearchProjection<P> build(SearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
            LuceneSearchProjection[] typedInners = new LuceneSearchProjection[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                typedInners[i] = LuceneSearchProjection.from(this.scope, inners[i]);
            }
            return new LuceneCompositeProjection(this, typedInners, compositor, accumulatorProvider.get());
        }
    }

    private class CompositeExtractor
    implements LuceneSearchProjection.Extractor<A, P> {
        private final LuceneSearchProjection.Extractor<?, ?>[] inners;

        private CompositeExtractor(LuceneSearchProjection.Extractor<?, ?>[] inners) {
            this.inners = inners;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + LuceneCompositeProjection.this.compositor + ", accumulator=" + LuceneCompositeProjection.this.accumulator + "]";
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            Values[] innerValues = new Values[this.inners.length];
            for (int i = 0; i < this.inners.length; ++i) {
                innerValues[i] = this.inners[i].values(context);
            }
            return new CompositeValues(innerValues);
        }

        @Override
        public final P transform(LoadingResult<?, ?> loadingResult, A accumulated, ProjectionTransformContext context) {
            for (int i = 0; i < LuceneCompositeProjection.this.accumulator.size(accumulated); ++i) {
                Object transformedData = LuceneCompositeProjection.this.accumulator.get(accumulated, i);
                for (int j = 0; j < this.inners.length; ++j) {
                    Object extractedDataForInner = LuceneCompositeProjection.this.compositor.get(transformedData, j);
                    Object transformedDataForInner = LuceneSearchProjection.Extractor.transformUnsafe(this.inners[j], loadingResult, extractedDataForInner, context);
                    transformedData = LuceneCompositeProjection.this.compositor.set(transformedData, j, transformedDataForInner);
                }
                accumulated = LuceneCompositeProjection.this.accumulator.transform(accumulated, i, LuceneCompositeProjection.this.compositor.finish(transformedData));
            }
            return LuceneCompositeProjection.this.accumulator.finish(accumulated);
        }

        private class CompositeValues
        implements Values<A> {
            private final Values<?>[] inners;

            private CompositeValues(Values<?>[] inners) {
                this.inners = inners;
            }

            @Override
            public void context(LeafReaderContext context) throws IOException {
                for (Values<?> inner : this.inners) {
                    inner.context(context);
                }
            }

            @Override
            public A get(int doc) throws IOException {
                Object accumulated = LuceneCompositeProjection.this.accumulator.createInitial();
                Object components = LuceneCompositeProjection.this.compositor.createInitial();
                for (int i = 0; i < this.inners.length; ++i) {
                    Object extractedDataForInner = this.inners[i].get(doc);
                    components = LuceneCompositeProjection.this.compositor.set(components, i, extractedDataForInner);
                }
                accumulated = LuceneCompositeProjection.this.accumulator.accumulate(accumulated, components);
                return accumulated;
            }
        }
    }
}

