/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;

public class LuceneRootContextProjection<P>
extends AbstractLuceneProjection<P> {
    private final LuceneSearchProjection<P> inner;

    public LuceneRootContextProjection(LuceneSearchIndexScope<?> scope, LuceneSearchProjection<P> inner) {
        super(scope);
        this.inner = inner;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inner=" + this.inner + "]";
    }

    @Override
    public LuceneSearchProjection.Extractor<?, P> request(ProjectionRequestContext context) {
        if (context.absoluteCurrentFieldPath() == null) {
            return this.inner.request(context);
        }
        ProjectionRequestContext innerContext = context.root();
        return new RootContextExtractor(context.absoluteCurrentFieldPath(), this.inner.request(innerContext));
    }

    private static class RootContextExtractor<E, P>
    implements LuceneSearchProjection.Extractor<E, P> {
        private final String contextAbsoluteFieldPath;
        private final LuceneSearchProjection.Extractor<E, P> inner;

        private RootContextExtractor(String contextAbsoluteFieldPath, LuceneSearchProjection.Extractor<E, P> inner) {
            this.contextAbsoluteFieldPath = contextAbsoluteFieldPath;
            this.inner = inner;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[contextAbsoluteFieldPath=" + this.contextAbsoluteFieldPath + "inner=" + this.inner + "]";
        }

        @Override
        public Values<E> values(ProjectionExtractContext context) {
            return new RootContextValues(this.inner.values(context));
        }

        @Override
        public P transform(LoadingResult<?, ?> loadingResult, E extractedData, ProjectionTransformContext context) {
            return this.inner.transform(loadingResult, extractedData, context);
        }

        private class RootContextValues
        implements Values<E> {
            private final Values<E> inner;
            private final QueryBitSetProducer rootFilter;
            private BitSet rootDocs;

            private RootContextValues(Values<E> inner) {
                this.inner = inner;
                this.rootFilter = new QueryBitSetProducer(Queries.mainDocumentQuery());
            }

            @Override
            public void context(LeafReaderContext context) throws IOException {
                this.rootDocs = this.rootFilter.getBitSet(context);
                this.inner.context(context);
            }

            @Override
            public E get(int childDoc) throws IOException {
                int rootDoc = this.rootDocs.nextSetBit(childDoc);
                return this.inner.get(rootDoc);
            }
        }
    }
}

