/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ProjectionRequestContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ExtractionRequirements.Builder extractionRequirementsBuilder;
    private final String absoluteCurrentFieldPath;

    public ProjectionRequestContext(ExtractionRequirements.Builder extractionRequirementsBuilder) {
        this(extractionRequirementsBuilder, null);
    }

    private ProjectionRequestContext(ExtractionRequirements.Builder extractionRequirementsBuilder, String absoluteCurrentFieldPath) {
        this.extractionRequirementsBuilder = extractionRequirementsBuilder;
        this.absoluteCurrentFieldPath = absoluteCurrentFieldPath;
    }

    public void requireAllStoredFields() {
        this.extractionRequirementsBuilder.requireAllStoredFields();
    }

    public void requireStoredField(String absoluteFieldPath, String nestedDocumentPath) {
        this.extractionRequirementsBuilder.requireStoredField(absoluteFieldPath, nestedDocumentPath);
    }

    public void requireScore() {
        this.extractionRequirementsBuilder.requireScore();
    }

    public void checkValidField(String absoluteFieldPath) {
        if (!FieldPaths.isStrictPrefix((String)this.absoluteCurrentFieldPath, (String)absoluteFieldPath)) {
            throw log.invalidContextForProjectionOnField(absoluteFieldPath, this.absoluteCurrentFieldPath);
        }
    }

    public ProjectionRequestContext root() {
        return new ProjectionRequestContext(this.extractionRequirementsBuilder, null);
    }

    public ProjectionRequestContext forField(String absoluteFieldPath) {
        this.checkValidField(absoluteFieldPath);
        return new ProjectionRequestContext(this.extractionRequirementsBuilder, absoluteFieldPath);
    }

    public String absoluteCurrentFieldPath() {
        return this.absoluteCurrentFieldPath;
    }
}

