/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.dsl.impl;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryOptionsStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQuerySelectStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryWhereStep;
import org.hibernate.search.backend.lucene.search.query.dsl.impl.LuceneSearchQueryOptionsStepImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleBooleanPredicateClausesCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQuerySelectStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class LuceneSearchQuerySelectStepImpl<R, E, LOS>
extends AbstractSearchQuerySelectStep<LuceneSearchQueryOptionsStep<E, LOS>, R, E, LOS, LuceneSearchProjectionFactory<R, E>, LuceneSearchPredicateFactory>
implements LuceneSearchQuerySelectStep<R, E, LOS> {
    private final LuceneSearchQueryIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final SearchLoadingContextBuilder<R, E, LOS> loadingContextBuilder;

    public LuceneSearchQuerySelectStepImpl(LuceneSearchQueryIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public LuceneSearchQueryWhereStep<E, LOS> selectEntity() {
        return this.select(this.scope.projectionFactory().entity().toProjection());
    }

    @Override
    public LuceneSearchQueryWhereStep<R, LOS> selectEntityReference() {
        return this.select(this.scope.projectionBuilders().entityReference());
    }

    @Override
    public <P> LuceneSearchQueryWhereStep<P, LOS> select(Class<P> objectClass) {
        return this.select(this.scope.projectionFactory().composite().as(objectClass).toProjection());
    }

    @Override
    public <P> LuceneSearchQueryWhereStep<P, LOS> select(Function<? super LuceneSearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        SearchProjection projection = projectionContributor.apply(this.scope.projectionFactory()).toProjection();
        return this.select(projection);
    }

    @Override
    public <P> LuceneSearchQueryWhereStep<P, LOS> select(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.scope.select(this.sessionContext, (SearchLoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return new LuceneSearchQueryOptionsStepImpl(this.scope, builder, this.loadingContextBuilder);
    }

    @Override
    public LuceneSearchQueryWhereStep<List<?>, LOS> select(SearchProjection<?> ... projections) {
        return this.select(this.scope.projectionBuilders().composite().build(projections, ProjectionCompositor.fromList((int)projections.length), ProjectionAccumulator.single()));
    }

    public LuceneSearchQueryOptionsStep<E, LOS> where(SearchPredicate predicate) {
        return (LuceneSearchQueryOptionsStep)this.selectEntity().where(predicate);
    }

    public LuceneSearchQueryOptionsStep<E, LOS> where(Function<? super LuceneSearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return (LuceneSearchQueryOptionsStep)this.selectEntity().where(predicateContributor);
    }

    public LuceneSearchQueryOptionsStep<E, LOS> where(BiConsumer<? super LuceneSearchPredicateFactory, ? super SimpleBooleanPredicateClausesCollector<?>> predicateContributor) {
        return (LuceneSearchQueryOptionsStep)this.selectEntity().where(predicateContributor);
    }

    protected LuceneSearchQueryIndexScope<?> scope() {
        return this.scope;
    }

    protected BackendSessionContext sessionContext() {
        return this.sessionContext;
    }

    protected SearchLoadingContextBuilder<R, E, LOS> loadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

