/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneLoadableSearchResult<H> {
    private final FromDocumentValueConvertContext fromDocumentValueConvertContext;
    private final LuceneSearchProjection.Extractor<?, H> rootExtractor;
    private final SearchResultTotal resultTotal;
    private final TopDocs topDocs;
    private List<Object> extractedData;
    private final Map<AggregationKey<?>, ?> extractedAggregations;
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final Duration took;
    private final Boolean timedOut;
    private final TimeoutManager timeoutManager;

    LuceneLoadableSearchResult(FromDocumentValueConvertContext fromDocumentValueConvertContext, LuceneSearchProjection.Extractor<?, H> rootExtractor, SearchResultTotal resultTotal, TopDocs topDocs, List<Object> extractedData, Map<AggregationKey<?>, ?> extractedAggregations, ProjectionHitMapper<?, ?> projectionHitMapper, Duration took, boolean timedOut, TimeoutManager timeoutManager) {
        this.fromDocumentValueConvertContext = fromDocumentValueConvertContext;
        this.rootExtractor = rootExtractor;
        this.resultTotal = resultTotal;
        this.topDocs = topDocs;
        this.extractedData = extractedData;
        this.extractedAggregations = extractedAggregations;
        this.projectionHitMapper = projectionHitMapper;
        this.took = took;
        this.timedOut = timedOut;
        this.timeoutManager = timeoutManager;
    }

    LuceneSearchResult<H> loadBlocking() {
        int readIndex;
        ProjectionTransformContext transformContext = new ProjectionTransformContext(this.fromDocumentValueConvertContext);
        LoadingResult loadingResult = this.projectionHitMapper.loadBlocking(this.timeoutManager.hardDeadlineOrNull());
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.extractedData.size(); ++readIndex) {
            transformContext.reset();
            H transformed = LuceneSearchProjection.Extractor.transformUnsafe(this.rootExtractor, loadingResult, this.extractedData.get(readIndex), transformContext);
            if (transformContext.hasFailedLoad()) continue;
            this.extractedData.set(writeIndex, transformed);
            ++writeIndex;
        }
        if (writeIndex < readIndex) {
            this.extractedData.subList(writeIndex, readIndex).clear();
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedData);
        this.extractedData = null;
        return new LuceneSearchResultImpl<Object>(this.resultTotal, loadedHits, this.extractedAggregations, this.took, this.timedOut, this.topDocs);
    }
}

