/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNamedPredicateOptions;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeCollector;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeContributor;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexObjectFieldTemplateBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexRootBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexValueFieldBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexValueFieldTemplateBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNamedPredicate;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexCompositeNodeType;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaNamedPredicateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexCompositeNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneIndexCompositeNodeBuilder
implements IndexCompositeNodeBuilder,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final LuceneIndexCompositeNodeType.Builder typeBuilder;
    private final Map<String, LuceneIndexNodeContributor> fields = new LinkedHashMap<String, LuceneIndexNodeContributor>();
    private final Map<String, LuceneIndexNodeContributor> templates = new LinkedHashMap<String, LuceneIndexNodeContributor>();
    private final Map<String, LuceneIndexNamedPredicateOptions> namedPredicates = new LinkedHashMap<String, LuceneIndexNamedPredicateOptions>();

    protected AbstractLuceneIndexCompositeNodeBuilder(LuceneIndexCompositeNodeType.Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> addField(String relativeFieldName, IndexFieldInclusion inclusion, IndexFieldType<F> indexFieldType) {
        LuceneIndexValueFieldType luceneIndexFieldType = (LuceneIndexValueFieldType)indexFieldType;
        LuceneIndexValueFieldBuilder childBuilder = new LuceneIndexValueFieldBuilder(this, relativeFieldName, inclusion, luceneIndexFieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public IndexObjectFieldBuilder addObjectField(String relativeFieldName, IndexFieldInclusion inclusion, ObjectStructure structure) {
        LuceneIndexObjectFieldBuilder objectFieldBuilder = new LuceneIndexObjectFieldBuilder(this, relativeFieldName, inclusion, structure);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaNamedPredicateOptionsStep addNamedPredicate(String name, IndexFieldInclusion inclusion, PredicateDefinition definition) {
        LuceneIndexNamedPredicateOptions options = new LuceneIndexNamedPredicateOptions(inclusion, definition);
        this.putNamedPredicate(name, options);
        if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
            this.typeBuilder.queryElementFactory(PredicateTypeKeys.named((String)name), new LuceneNamedPredicate.Factory(options.definition, name));
        }
        return options;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addFieldTemplate(String templateName, IndexFieldInclusion inclusion, IndexFieldType<?> indexFieldType, String prefix) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        LuceneIndexValueFieldType elasticsearchIndexFieldType = (LuceneIndexValueFieldType)indexFieldType;
        LuceneIndexValueFieldTemplateBuilder templateBuilder = new LuceneIndexValueFieldTemplateBuilder(this, prefixedTemplateName, inclusion, elasticsearchIndexFieldType, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addObjectFieldTemplate(String templateName, ObjectStructure structure, String prefix, IndexFieldInclusion inclusion) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        LuceneIndexObjectFieldTemplateBuilder templateBuilder = new LuceneIndexObjectFieldTemplateBuilder(this, prefixedTemplateName, inclusion, structure, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public abstract LuceneIndexRootBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    final void contributeChildren(LuceneIndexCompositeNode node, LuceneIndexNodeCollector collector, Map<String, LuceneIndexField> staticChildrenByNameForParent) {
        for (LuceneIndexNodeContributor contributor : this.fields.values()) {
            contributor.contribute(collector, node, staticChildrenByNameForParent);
        }
        for (LuceneIndexNodeContributor template : this.templates.values()) {
            template.contribute(collector, node, staticChildrenByNameForParent);
        }
    }

    private void putField(String name, LuceneIndexNodeContributor contributor) {
        LuceneIndexNodeContributor previous = this.fields.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.eventContext());
        }
    }

    private void putTemplate(String name, LuceneIndexNodeContributor contributor) {
        LuceneIndexNodeContributor previous = this.templates.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaFieldTemplateNameConflict(name, this.eventContext());
        }
    }

    private void putNamedPredicate(String name, LuceneIndexNamedPredicateOptions options) {
        LuceneIndexNamedPredicateOptions previous = this.namedPredicates.putIfAbsent(name, options);
        if (previous != null) {
            throw log.indexSchemaNamedPredicateNameConflict(name, this.eventContext());
        }
    }
}

