/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import java.time.temporal.TemporalAccessor;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneNumericFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneTextFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneDocumentValueSort;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneStandardFieldSort
extends AbstractLuceneDocumentValueSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneStandardFieldSort(AbstractBuilder<?, ?, ?> builder) {
        super(builder);
    }

    static abstract class AbstractBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
    extends AbstractLuceneDocumentValueSort.AbstractBuilder
    implements FieldSortBuilder {
        protected final LuceneSearchIndexValueFieldContext<F> field;
        protected final C codec;
        private final Object sortMissingValueFirstPlaceholder;
        private final Object sortMissingValueLastPlaceholder;
        protected Object missingValue = SortMissingValue.MISSING_LAST;

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, C codec, Object sortMissingValueFirstPlaceholder, Object sortMissingValueLastPlaceholder) {
            super(scope, field);
            this.field = field;
            this.codec = codec;
            this.sortMissingValueFirstPlaceholder = sortMissingValueFirstPlaceholder;
            this.sortMissingValueLastPlaceholder = sortMissingValueLastPlaceholder;
        }

        public void missingFirst() {
            this.missingValue = SortMissingValue.MISSING_FIRST;
        }

        public void missingLast() {
            this.missingValue = SortMissingValue.MISSING_LAST;
        }

        public void missingHighest() {
            this.missingValue = SortMissingValue.MISSING_HIGHEST;
        }

        public void missingLowest() {
            this.missingValue = SortMissingValue.MISSING_LOWEST;
        }

        public void missingAs(Object value, ValueConvert convert) {
            DslConverter dslToIndexConverter = this.field.type().dslConverter(convert);
            try {
                Object converted = dslToIndexConverter.unknownTypeToDocumentValue(value, this.scope.toDocumentValueConvertContext());
                this.missingValue = this.encodeMissingAs(converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, this.getEventContext());
            }
        }

        public SearchSort build() {
            return new LuceneStandardFieldSort(this);
        }

        protected Object encodeMissingAs(F converted) {
            return this.codec.encode(converted);
        }

        protected final Object getEffectiveMissingValue() {
            Object effectiveMissingValue = this.missingValue == SortMissingValue.MISSING_FIRST ? (this.order == SortOrder.DESC ? this.sortMissingValueLastPlaceholder : this.sortMissingValueFirstPlaceholder) : (this.missingValue == SortMissingValue.MISSING_LAST ? (this.order == SortOrder.DESC ? this.sortMissingValueFirstPlaceholder : this.sortMissingValueLastPlaceholder) : (this.missingValue == SortMissingValue.MISSING_LOWEST ? this.sortMissingValueFirstPlaceholder : (this.missingValue == SortMissingValue.MISSING_HIGHEST ? this.sortMissingValueLastPlaceholder : this.missingValue)));
            return effectiveMissingValue;
        }
    }

    private static class TemporalFieldBuilder<F extends TemporalAccessor, E extends Number>
    extends NumericFieldBuilder<F, E> {
        private TemporalFieldBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(codec, scope, field);
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: 
                case AVG: 
                case MEDIAN: {
                    super.mode(mode);
                    break;
                }
                case SUM: {
                    throw log.invalidSortModeForTemporalField(mode, this.getEventContext());
                }
            }
        }
    }

    public static class TemporalFieldFactory<F extends TemporalAccessor, E extends Number>
    extends AbstractFactory<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        public TemporalFieldFactory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TemporalFieldBuilder((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }

    private static class TextFieldBuilder<F>
    extends AbstractBuilder<F, String, LuceneStandardFieldCodec<F, String>> {
        private TextFieldBuilder(LuceneStandardFieldCodec<F, String> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field, codec, SortField.STRING_FIRST, SortField.STRING_LAST);
        }

        @Override
        protected Object encodeMissingAs(F converted) {
            return this.normalize((String)this.codec.encode(converted));
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: {
                    super.mode(mode);
                    break;
                }
                default: {
                    throw log.invalidSortModeForStringField(mode, this.getEventContext());
                }
            }
        }

        @Override
        protected LuceneFieldComparatorSource toFieldComparatorSource() {
            return new LuceneTextFieldComparatorSource(this.nestedDocumentPath, this.missingValue, this.getMultiValueMode(), this.getNestedFilter());
        }

        private BytesRef normalize(String value) {
            if (value == null) {
                return null;
            }
            Analyzer searchAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            return searchAnalyzerOrNormalizer.normalize(this.absoluteFieldPath, value);
        }
    }

    public static class TextFieldFactory<F>
    extends AbstractFactory<F, String, LuceneStandardFieldCodec<F, String>> {
        public TextFieldFactory(LuceneStandardFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TextFieldBuilder((LuceneStandardFieldCodec)this.codec, scope, field);
        }
    }

    private static class NumericFieldBuilder<F, E extends Number>
    extends AbstractBuilder<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        private NumericFieldBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field, codec, codec.getDomain().getMinValue(), codec.getDomain().getMaxValue());
        }

        @Override
        protected LuceneFieldComparatorSource toFieldComparatorSource() {
            return new LuceneNumericFieldComparatorSource<Number>(this.nestedDocumentPath, ((AbstractLuceneNumericFieldCodec)this.codec).getDomain(), (Number)this.getEffectiveMissingValue(), this.getMultiValueMode(), this.getNestedFilter());
        }
    }

    public static class NumericFieldFactory<F, E extends Number>
    extends AbstractFactory<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        public NumericFieldFactory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new NumericFieldBuilder((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }

    static abstract class AbstractFactory<F, E, C extends LuceneStandardFieldCodec<F, E>>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<FieldSortBuilder, F, C> {
        protected AbstractFactory(C codec) {
            super(codec);
        }
    }
}

