/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(Path absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return "HSEARCH000041: Index directory does not exist, creating: '%1$s'";
    }

    @Override
    public final void indexWriterResetAfterFailure(EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.indexWriterResetAfterFailure$str(), (Object)new EventContextFormatter(context));
    }

    protected String indexWriterResetAfterFailure$str() {
        return "HSEARCH000052: An index writer operation failed. Resetting the index writer and forcing release of locks. %1$s";
    }

    @Override
    public final void unableToCloseIndexReader(EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseIndexReader$str(), (Object)new EventContextFormatter(context));
    }

    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }

    @Override
    public final void recommendConfiguringLuceneVersion(String key, Version latest, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), (Object)key, (Object)latest, (Object)new EventContextFormatter(context));
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Missing value for configuration property '%1$s': using LATEST (currently '%2$s'). %3$s";
    }

    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Resource does not exist in classpath: '%1$s'";
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String indexMergeOperation$str() {
        return "Index Merge operation on index '%1$s'";
    }

    @Override
    public final String indexMergeOperation(String indexName) {
        return String.format(this.getLoggingLocale(), this.indexMergeOperation$str(), indexName);
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription, EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: Unable to acquire lock on the index while initializing directory '%s'. Either the directory wasn't properly closed last time it was used due to a critical failure, or another instance of Hibernate Search is using it concurrently (which is not supported). If you experience indexing failures on this index you will need to remove the lock, and might need to rebuild the index.";
    }

    @Override
    public final void logInfoStreamMessage(String componentName, String message) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.logInfoStreamMessage$str(), (Object)componentName, (Object)message);
    }

    protected String logInfoStreamMessage$str() {
        return "HSEARCH000226: %s: %s";
    }

    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Unable to parse '%1$ss' into a Lucene version: %2$s";
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String property, String luceneErrorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalLuceneVersionFormat$str(), property, luceneErrorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void executingLuceneQuery(Query luceneQuery) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executingLuceneQuery$str(), (Object)luceneQuery);
    }

    protected String executingLuceneQuery$str() {
        return "HSEARCH000274: Executing Lucene query: %s";
    }

    protected String unableToOpenIndexReaders$str() {
        return "HSEARCH000284: Unable to open index readers: %1$s";
    }

    @Override
    public final SearchException unableToOpenIndexReaders(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOpenIndexReaders$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Unable to apply analysis configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, String value1, String value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void normalizerProducedMultipleTokens(String normalizerName, int token) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.normalizerProducedMultipleTokens$str(), (Object)normalizerName, (Object)token);
    }

    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: Invalid normalizer implementation: the normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }

    @Override
    public final SearchException unknownAnalyzer(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzer$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }

    @Override
    public final SearchException pathIsNotWriteableDirectory(Path rootDirectory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.pathIsNotWriteableDirectory$str(), rootDirectory));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: Invalid target for Lucene extension: '%1$s'. This extension can only be applied to components created by a Lucene backend.";
    }

    @Override
    public final SearchException luceneExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.luceneExtensionOnUnknownType$str(), context));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: Invalid search predicate: '%1$s'. You must build the predicate from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: Invalid search sort: '%1$s'. You must build the sort from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }

    @Override
    public final SearchException unableToInitializeIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }

    @Override
    public final SearchException unableToIndexEntry(String tenantId, String entityTypeName, Object entityIdentifier, String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToIndexEntry$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }

    @Override
    public final SearchException unableToDeleteEntryFromIndex(String tenantId, String entityTypeName, Object entityIdentifier, String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteEntryFromIndex$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit: %1$s";
    }

    @Override
    public final SearchException unableToCommitIndex(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCommitIndex$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: Invalid multi-index scope: a scope cannot span both a Lucene index and another type of index. Base scope: '%1$s', incompatible (Lucene) index: '%2$s'.";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder baseScope, LuceneIndexManager luceneIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: Invalid multi-index scope: a scope cannot span multiple Lucene backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder baseScope, LuceneIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: Unable to execute search query '%1$s': %2$s";
    }

    @Override
    public final SearchException ioExceptionOnQueryExecution(Query luceneQuery, String causeMessage, EventContext context, IOException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnQueryExecution$str(), luceneQuery, causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(Set<String> tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Invalid requested type for this backend: '%1$s'. Lucene backends can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH600034: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(int totalShouldClauseNumber, int minimum) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ignoreConstraintCeiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldPath(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldPath$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL argument: %1$s";
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Invalid requested type for this index manager: '%1$s'. Lucene index managers can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToCreateAnalyzer(String name, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalyzer$str(), name, causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToCreateNormalizer(String name, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateNormalizer$str(), name, causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }

    @Override
    public final SearchException unknownNormalizer(String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNormalizer$str(), normalizerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: Invalid search projection: '%1$s'. You must build the projection from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToShutdownShard$str() {
        return "HSEARCH600061: Unable to shut down index: %1$s";
    }

    @Override
    public final SearchException unableToShutdownShard(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToShutdownShard$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH600062: No built-in index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries matching query '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(Query query, String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteAllEntriesFromIndex$str(), query, causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Full-text features (analysis, fuzziness) are not supported for fields of this type.";
    }

    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fullTextFeaturesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absoluteFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresTypeName$str() {
        return "HSEARCH600075: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }

    @Override
    public final SearchException explainRequiresTypeName(Set<String> targetedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeName$str(), targetedTypeNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH600076: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(Set<String> targetedTypeNames, String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainUnknownDocument$str() {
        return "HSEARCH600077: Invalid document identifier: '%2$s'. No such document for type '%1$s'.";
    }

    @Override
    public final SearchException explainUnknownDocument(String typeName, String id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnknownDocument$str(), typeName, id));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToMergeSegments$str() {
        return "HSEARCH600078: Unable to merge index segments: %1$s";
    }

    @Override
    public final SearchException unableToMergeSegments(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToMergeSegments$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCloseIndexWriterAfterFailures$str() {
        return "HSEARCH600079: Unable to close the index writer after write failures: %1$s";
    }

    @Override
    public final SearchException unableToCloseIndexWriterAfterFailures(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCloseIndexWriterAfterFailures$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH600080: Invalid index field type: missing decimal scale. Define the decimal scale explicitly. %1$s";
    }

    @Override
    public final SearchException nullDecimalScale(String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), hint), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value, Number min, Number max) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value, min, max));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH600082: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s, but the given predicate was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s, but the given sort was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s, but the given projection was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidFileSystemAccessStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidLockingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: Incorrect sharding strategy implementation: strategy '%1$s' did not declare any shard identifiers during initialization. Declare shard identifiers using context.shardIdentifiers(...) or, if sharding is disabled, call context.disableSharding().";
    }

    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object strategy) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: When using sharding strategy '%1$s', this configuration property must be set.";
    }

    @Override
    public final SearchException missingPropertyValueForShardingStrategy(String strategyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyValueForShardingStrategy$str(), strategyName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }

    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(String invalidKey, Collection<String> validKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: Invalid search aggregation: '%1$s'. You must build the aggregation from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s, but the given aggregation was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Duplicate aggregation definitions for key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }

    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(String searchAnalyzer, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidIOStrategyName$str() {
        return "HSEARCH600108: Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidIOStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIOStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingIndex$str() {
        return "HSEARCH600109: Index does not exist for directory '%1$s'";
    }

    @Override
    public final SearchException missingIndex(Directory directory, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingIndex$str(), directory), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToValidateIndexDirectory$str() {
        return "HSEARCH600110: Unable to validate index directory: %1$s";
    }

    @Override
    public final SearchException unableToValidateIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToValidateIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDropIndexDirectory$str() {
        return "HSEARCH600111: Unable to drop index directory: %1$s";
    }

    @Override
    public final SearchException unableToDropIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDropIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH600114: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }

    @Override
    public final SearchException invalidSortModeAcrossNested(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeAcrossNested$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForStringField$str() {
        return "HSEARCH600115: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }

    @Override
    public final SearchException invalidSortModeForStringField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForStringField$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH600116: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForTemporalField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForTemporalField$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH600117: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForDistanceSort(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForDistanceSort$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String uncommittedOperationsBecauseOfFailure$str() {
        return "HSEARCH600118: A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s";
    }

    @Override
    public final SearchException uncommittedOperationsBecauseOfFailure(String causeMessage, EventContext context, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uncommittedOperationsBecauseOfFailure$str(), causeMessage), cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH600120: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH600121: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }

    @Override
    public final SearchException invalidNestedObjectPathForPredicate(SearchPredicate predicate, String nestedObjectPath, List<String> fieldPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH600122: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalIndexWriterSetting$str() {
        return "HSEARCH600123: Invalid value for IndexWriter setting '%1$s': '%2$s'. %3$s";
    }

    @Override
    public final SearchException illegalIndexWriterSetting(String settingName, Object settingValue, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalIndexWriterSetting$str(), settingName, settingValue, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalMergePolicySetting$str() {
        return "HSEARCH600124: Invalid value for merge policy setting '%1$s': '%2$s'. %3$s";
    }

    @Override
    public final SearchException illegalMergePolicySetting(String settingName, Object settingValue, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalMergePolicySetting$str(), settingName, settingValue, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH600125: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaFieldTemplateNameConflict$str(), name), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldValueType$str() {
        return "HSEARCH600126: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldValueType(Class<?> fieldValueType, Class<?> invalidValueType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldValueType$str(), new ClassFormatter(fieldValueType), new ClassFormatter(invalidValueType)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownFieldForIndexing$str() {
        return "HSEARCH600127: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForIndexing(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForIndexing$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH600131: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.multi()' when you create the projection.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(String absolutePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH600135: Implementation class differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentImplementationClassForQueryElement(Class<?> class1, Class<?> class2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentImplementationClassForQueryElement$str(), new ClassFormatter(class1), new ClassFormatter(class2)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH600136: Field codec differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentFieldCodecForQueryElement(Object codec1, Object codec2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentFieldCodecForQueryElement$str(), codec1, codec2));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToComputeIndexSize$str() {
        return "HSEARCH600141: Unable to compute size of index: %1$s";
    }

    @Override
    public final SearchException unableToComputeIndexSize(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToComputeIndexSize$str(), causeMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAnalysisComponent$str() {
        return "HSEARCH600142: Unable to create instance of analysis component '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToCreateAnalysisComponent(Class<?> type, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalysisComponent$str(), new ClassFormatter(type), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH600143: The index schema named predicate '%1$s' was added twice.";
    }

    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(String relativeFilterName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH600144: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(Object predicateDefinition1, Object predicateDefinition2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToApplyQueryCacheConfiguration$str() {
        return "HSEARCH600146: Unable to apply query caching configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyQueryCacheConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyQueryCacheConfiguration$str(), errorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH600148: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButExplicitlyDisabledByBackend$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH600149: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String paramNotDefined$str() {
        return "HSEARCH600150: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }

    @Override
    public final SearchException paramNotDefined(String name, String predicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.paramNotDefined$str(), name, predicateName), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String offsetLimitExceedsMaxValue$str() {
        return "HSEARCH600151: Offset + limit should be lower than Integer.MAX_VALUE, offset: '%1$s', limit: '%2$s'.";
    }

    @Override
    public final IOException offsetLimitExceedsMaxValue(int offset, Integer limit) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.offsetLimitExceedsMaxValue$str(), offset, limit));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH600152: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }

    @Override
    public final SearchException invalidContextForProjectionOnField(String absolutePath, String objectFieldAbsolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH600153: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.multi()' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).multi()'.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(String absolutePath, String objectFieldAbsolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToStartShard$str() {
        return "HSEARCH600154: Unable to start index: %1$s";
    }

    @Override
    public final SearchException unableToStartShard(String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToStartShard$str(), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH600155: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }

    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(String typeName, Set<String> expectedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode$str() {
        return "This multi-valued field has a 'FLATTENED' structure, which means the structure of objects is not preserved upon indexing, making object projections impossible. Try setting the field structure to 'NESTED' and reindexing all your data.";
    }

    @Override
    public final String missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode() {
        return String.format(this.getLoggingLocale(), this.missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode$str(), new Object[0]);
    }

    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH600156: Nonblocking operation submitter is not supported.";
    }

    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonblockingOperationSubmitterNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToExportSchema$str() {
        return "HSEARCH600157: Unable to export the schema for '%1$s' index: %2$s";
    }

    @Override
    public final SearchException unableToExportSchema(String indexName, String message, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToExportSchema$str(), indexName, message), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH600158: Invalid highlighter: '%1$s'. You must build the highlighter from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherQueryHighlighters(SearchHighlighter highlighter) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH600159: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s, but the given highlighter was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(SearchHighlighter highlighter, Set<String> indexNames, Set<String> hibernateSearchIndexNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, indexNames, hibernateSearchIndexNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixDifferentHighlighterTypesAtOverrideLevel$str() {
        return "HSEARCH600160: Overriding a '%2$s' highlighter with a '%1$s' is not supported. Overriding highlighters should be of the same type as the global is if the global highlighter was configured.";
    }

    @Override
    public final SearchException cannotMixDifferentHighlighterTypesAtOverrideLevel(SearchHighlighterType override, SearchHighlighterType parent) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixDifferentHighlighterTypesAtOverrideLevel$str(), override, parent));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindHighlighterWithName$str() {
        return "HSEARCH600161: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }

    @Override
    public final SearchException cannotFindHighlighterWithName(String name, Collection<String> availableHighlighterNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindHighlighterWithName$str(), name, availableHighlighterNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedBoundaryScannerType$str() {
        return "HSEARCH600162: '%1$s' highlighter does not support '%2$s' boundary scanner type.";
    }

    @Override
    public final SearchException unsupportedBoundaryScannerType(String type, BoundaryScannerType boundaryScannerType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedBoundaryScannerType$str(), type, boundaryScannerType));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH600163: Named highlighters cannot use a blank string as name.";
    }

    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterNameCannotBeBlank$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH600164: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }

    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(String highlighterName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH600165: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }

    @Override
    public final SearchException highlighterTypeNotSupported(SearchHighlighterType type, String field) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterTypeNotSupported$str(), type, field));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedMixOfHighlightableValues$str() {
        return "HSEARCH600166: Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'";
    }

    @Override
    public final SearchException unsupportedMixOfHighlightableValues(Set<Highlightable> highlightable) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedMixOfHighlightableValues$str(), highlightable));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String termVectorDontAllowFastVectorHighlighter$str() {
        return "HSEARCH600167: The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.";
    }

    @Override
    public final SearchException termVectorDontAllowFastVectorHighlighter(TermVector termVector) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.termVectorDontAllowFastVectorHighlighter$str(), termVector));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noHighlightableProvided$str() {
        return "HSEARCH600168: Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.";
    }

    @Override
    public final SearchException noHighlightableProvided() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noHighlightableProvided$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void unifiedHighlighterNoMatchSizeWarning(Integer value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unifiedHighlighterNoMatchSizeWarning$str(), (Object)value);
    }

    protected String unifiedHighlighterNoMatchSizeWarning$str() {
        return "HSEARCH600169: Lucene's unified highlighter cannot limit the size of a fragment returned when no match is found. Instead if no match size was set to any positive integer - all text will be returned. Configured value '%1$s' will be ignored, and the fragment will not be limited. If you don't want to see this warning set the value to Integer.MAX_VALUE.";
    }

    protected String unifiedHighlighterFragmentSizeNotSupported$str() {
        return "HSEARCH600170: Lucene's unified highlighter does not support the size fragment setting. Either use a plain or fast vector highlighters, or do not set this setting.";
    }

    @Override
    public final SearchException unifiedHighlighterFragmentSizeNotSupported() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unifiedHighlighterFragmentSizeNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH600171: Highlight projection cannot be applied within nested context of '%1$s'.";
    }

    @Override
    public final SearchException cannotHighlightInNestedContext(String currentNestingField, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH600172: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }

    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHighlightFieldFromNestedObjectStructure$str(), new Object[0]), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH600173: '%1$s' cannot be nested in an object projection. %2$s";
    }

    @Override
    public final SearchException cannotUseProjectionInNestedContext(String projection, String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorPropertyUnsupportedValue$str() {
        return "HSEARCH600174: Vector '%1$s' cannot be equal to '%2$s'. It must be a positive integer value lesser than or equal to %3$s.";
    }

    @Override
    public final SearchException vectorPropertyUnsupportedValue(String property, Integer value, int max) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorPropertyUnsupportedValue$str(), property, value, max));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGuessVectorFieldType$str() {
        return "HSEARCH600175: No built-in vector index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessVectorFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessVectorFieldType$str(), new ClassFormatter(inputType)), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorKnnMatchVectorTypeDiffersFromField$str() {
        return "HSEARCH600176: Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.";
    }

    @Override
    public final SearchException vectorKnnMatchVectorTypeDiffersFromField(String absoluteFieldPath, Class<?> expected, Class<?> actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorKnnMatchVectorTypeDiffersFromField$str(), absoluteFieldPath, new ClassFormatter(expected), new ClassFormatter(actual)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiValuedFieldNotAllowed$str() {
        return "HSEARCH600177: Fields of this type cannot be multivalued.";
    }

    @Override
    public final SearchException multiValuedFieldNotAllowed(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiValuedFieldNotAllowed$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorKnnMatchVectorDimensionDiffersFromField$str() {
        return "HSEARCH600178: Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.";
    }

    @Override
    public final SearchException vectorKnnMatchVectorDimensionDiffersFromField(String absoluteFieldPath, int expected, int actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorKnnMatchVectorDimensionDiffersFromField$str(), absoluteFieldPath, expected, actual));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullVectorDimension$str() {
        return "HSEARCH600179: Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s";
    }

    @Override
    public final SearchException nullVectorDimension(String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullVectorDimension$str(), hint), eventContext);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

