/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonMinimumShouldMatchConstraint;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneBooleanPredicate
extends AbstractLuceneSearchPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<LuceneSearchPredicate> mustClauses;
    private final List<LuceneSearchPredicate> mustNotClauses;
    private final List<LuceneSearchPredicate> shouldClauses;
    private final List<LuceneSearchPredicate> filterClauses;
    private final NavigableMap<Integer, LuceneCommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    private LuceneBooleanPredicate(Builder builder) {
        super(builder);
        this.mustClauses = builder.mustClauses;
        this.mustNotClauses = builder.mustNotClauses;
        this.shouldClauses = builder.shouldClauses;
        this.filterClauses = builder.filterClauses;
        this.minimumShouldMatchConstraints = builder.minimumShouldMatchConstraints;
        builder.mustClauses = null;
        builder.shouldClauses = null;
        builder.mustNotClauses = null;
        builder.filterClauses = null;
        builder.minimumShouldMatchConstraints = null;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.checkNestableWithin(expectedParentNestedPath, this.mustClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.shouldClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.filterClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.mustNotClauses);
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        this.contributeQueries(context, booleanQueryBuilder, this.mustClauses, BooleanClause.Occur.MUST);
        this.contributeQueries(context, booleanQueryBuilder, this.mustNotClauses, BooleanClause.Occur.MUST_NOT);
        this.contributeQueries(context, booleanQueryBuilder, this.shouldClauses, BooleanClause.Occur.SHOULD);
        this.contributeQueries(context, booleanQueryBuilder, this.filterClauses, BooleanClause.Occur.FILTER);
        if (this.isOnlyMustNot()) {
            booleanQueryBuilder.add((Query)new MatchAllDocsQuery(), super.hasNoModifiers() ? BooleanClause.Occur.FILTER : BooleanClause.Occur.MUST);
        }
        if (this.minimumShouldMatchConstraints != null && this.shouldClauses != null) {
            int minimumShouldMatch = LuceneCommonMinimumShouldMatchConstraint.minimumShouldMatch(this.minimumShouldMatchConstraints, this.shouldClauses);
            booleanQueryBuilder.setMinimumNumberShouldMatch(minimumShouldMatch);
        }
        return booleanQueryBuilder.build();
    }

    private void contributeQueries(PredicateRequestContext context, BooleanQuery.Builder booleanQueryBuilder, List<LuceneSearchPredicate> clauses, BooleanClause.Occur occur) {
        if (clauses == null) {
            return;
        }
        for (LuceneSearchPredicate clause : clauses) {
            booleanQueryBuilder.add(clause.toQuery(context), occur);
        }
    }

    private void checkNestableWithin(String expectedParentNestedPath, List<LuceneSearchPredicate> clauses) {
        if (clauses == null) {
            return;
        }
        for (LuceneSearchPredicate clause : clauses) {
            clause.checkNestableWithin(expectedParentNestedPath);
        }
    }

    private boolean isOnlyMustNot() {
        return !(this.mustNotClauses == null || this.mustNotClauses.isEmpty() || this.mustClauses != null && !this.mustClauses.isEmpty() || this.shouldClauses != null && !this.shouldClauses.isEmpty() || this.filterClauses != null && !this.filterClauses.isEmpty());
    }

    private boolean hasOnlyOneMustNotClause() {
        return this.isOnlyMustNot() && this.mustNotClauses.size() == 1;
    }

    @Override
    protected boolean hasNoModifiers() {
        return this.minimumShouldMatchConstraints == null && super.hasNoModifiers();
    }

    static class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements BooleanPredicateBuilder {
        private List<LuceneSearchPredicate> mustClauses;
        private List<LuceneSearchPredicate> mustNotClauses;
        private List<LuceneSearchPredicate> shouldClauses;
        private List<LuceneSearchPredicate> filterClauses;
        private NavigableMap<Integer, LuceneCommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void must(SearchPredicate clause) {
            if (this.mustClauses == null) {
                this.mustClauses = new ArrayList<LuceneSearchPredicate>();
            }
            this.mustClauses.add(LuceneSearchPredicate.from(this.scope, clause));
        }

        public void mustNot(SearchPredicate clause) {
            if (this.mustNotClauses == null) {
                this.mustNotClauses = new ArrayList<LuceneSearchPredicate>();
            }
            this.mustNotClauses.add(LuceneSearchPredicate.from(this.scope, clause));
        }

        public void should(SearchPredicate clause) {
            if (this.shouldClauses == null) {
                this.shouldClauses = new ArrayList<LuceneSearchPredicate>();
            }
            this.shouldClauses.add(LuceneSearchPredicate.from(this.scope, clause));
        }

        public void filter(SearchPredicate clause) {
            if (this.filterClauses == null) {
                this.filterClauses = new ArrayList<LuceneSearchPredicate>();
            }
            this.filterClauses.add(LuceneSearchPredicate.from(this.scope, clause));
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new LuceneCommonMinimumShouldMatchConstraint(matchingClausesNumber, null));
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new LuceneCommonMinimumShouldMatchConstraint(null, matchingClausesPercent));
        }

        public boolean hasClause() {
            return this.mustClauses != null || this.shouldClauses != null || this.mustNotClauses != null || this.filterClauses != null;
        }

        public SearchPredicate build() {
            this.optimizeClauseCollection(this.mustClauses, this::mustNot);
            this.optimizeClauseCollection(this.mustNotClauses, this::must);
            this.checkAndClearClauseCollections();
            if (this.hasNoModifiers()) {
                if (this.hasOnlyOneMustClause()) {
                    return this.mustClauses.get(0);
                }
                if (this.hasOnlyOneShouldClause()) {
                    return this.shouldClauses.get(0);
                }
            }
            return new LuceneBooleanPredicate(this);
        }

        private void optimizeClauseCollection(List<LuceneSearchPredicate> collection, Consumer<LuceneSearchPredicate> newCollection) {
            if (collection != null) {
                Iterator<LuceneSearchPredicate> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    LuceneSearchPredicate clause = iterator.next();
                    if (!(clause instanceof LuceneBooleanPredicate) || !((LuceneBooleanPredicate)clause).hasOnlyOneMustNotClause() || !((LuceneBooleanPredicate)clause).hasNoModifiers()) continue;
                    iterator.remove();
                    newCollection.accept(((LuceneBooleanPredicate)clause).mustNotClauses.get(0));
                }
            }
        }

        private void checkAndClearClauseCollections() {
            if (this.mustClauses != null && this.mustClauses.isEmpty()) {
                this.mustClauses = null;
            }
            if (this.mustNotClauses != null && this.mustNotClauses.isEmpty()) {
                this.mustNotClauses = null;
            }
        }

        private boolean hasOnlyOneMustClause() {
            return !(this.mustClauses == null || this.mustClauses.size() != 1 || this.mustNotClauses != null && !this.mustNotClauses.isEmpty() || this.shouldClauses != null && !this.shouldClauses.isEmpty() || this.filterClauses != null && !this.filterClauses.isEmpty());
        }

        private boolean hasOnlyOneShouldClause() {
            return !(this.shouldClauses == null || this.shouldClauses.size() != 1 || this.mustNotClauses != null && !this.mustNotClauses.isEmpty() || this.mustClauses != null && !this.mustClauses.isEmpty() || this.filterClauses != null && !this.filterClauses.isEmpty());
        }

        @Override
        protected boolean hasNoModifiers() {
            return this.minimumShouldMatchConstraints == null && super.hasNoModifiers();
        }

        private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, LuceneCommonMinimumShouldMatchConstraint constraint) {
            LuceneCommonMinimumShouldMatchConstraint previous;
            if (this.minimumShouldMatchConstraints == null) {
                this.minimumShouldMatchConstraints = new TreeMap<Integer, LuceneCommonMinimumShouldMatchConstraint>();
            }
            if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
                throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
            }
        }
    }
}

