/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonQueryStringPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.QueryStringPredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneQueryStringPredicate
extends LuceneCommonQueryStringPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneQueryStringPredicate(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends LuceneCommonQueryStringPredicate.Builder
    implements QueryStringPredicateBuilder {
        private Boolean allowLeadingWildcard = true;
        private Boolean enablePositionIncrements = true;
        private Integer phraseSlop;
        private RewriteMethod rewriteMethod;
        private Integer rewriteN;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void allowLeadingWildcard(boolean allowLeadingWildcard) {
            this.allowLeadingWildcard = allowLeadingWildcard;
        }

        public void enablePositionIncrements(boolean enablePositionIncrements) {
            this.enablePositionIncrements = enablePositionIncrements;
        }

        public void phraseSlop(Integer phraseSlop) {
            this.phraseSlop = phraseSlop;
        }

        public void rewriteMethod(RewriteMethod rewriteMethod, Integer n) {
            this.rewriteMethod = rewriteMethod;
            this.rewriteN = n;
        }

        public SearchPredicate build() {
            return new LuceneQueryStringPredicate(this);
        }

        @Override
        protected SearchQueryElementTypeKey<LuceneCommonQueryStringPredicateBuilderFieldState> typeKey() {
            return LucenePredicateTypeKeys.QUERY_STRING;
        }

        @Override
        protected Query buildQuery() {
            if (this.queryString == null || this.queryString.trim().isEmpty()) {
                return new MatchNoDocsQuery();
            }
            MultiFieldQueryParser queryParser = this.create(this.buildWeights(), this.buildAnalyzer());
            queryParser.setDefaultOperator(Builder.toOperator(this.defaultOperator));
            if (this.rewriteMethod != null) {
                queryParser.setMultiTermRewriteMethod(this.toRewriteMethod(this.rewriteMethod, this.rewriteN));
            }
            if (this.allowLeadingWildcard != null) {
                queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard.booleanValue());
            }
            if (this.enablePositionIncrements != null) {
                queryParser.setEnablePositionIncrements(this.enablePositionIncrements.booleanValue());
            }
            if (this.phraseSlop != null) {
                queryParser.setPhraseSlop(this.phraseSlop.intValue());
            }
            try {
                return this.applyMinimumShouldMatch(queryParser.parse(this.queryString));
            }
            catch (ParseException e) {
                throw log.queryStringParseException(this.queryString, e.getMessage(), (Exception)((Object)e));
            }
        }

        private MultiFieldQueryParser create(Map<String, Float> weights, Analyzer analyzer) {
            String[] fields = (String[])weights.keySet().toArray(String[]::new);
            return new MultiFieldQueryParser(fields, analyzer, weights);
        }

        private MultiTermQuery.RewriteMethod toRewriteMethod(RewriteMethod rewriteMethod, Integer n) {
            switch (rewriteMethod) {
                case CONSTANT_SCORE: {
                    return MultiTermQuery.CONSTANT_SCORE_REWRITE;
                }
                case CONSTANT_SCORE_BOOLEAN: {
                    return MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE;
                }
                case SCORING_BOOLEAN: {
                    return MultiTermQuery.SCORING_BOOLEAN_REWRITE;
                }
                case TOP_TERMS_BLENDED_FREQS_N: {
                    return new MultiTermQuery.TopTermsBlendedFreqScoringRewrite(n.intValue());
                }
                case TOP_TERMS_BOOST_N: {
                    return new MultiTermQuery.TopTermsBoostOnlyBooleanQueryRewrite(n.intValue());
                }
                case TOP_TERMS_N: {
                    return new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(n.intValue());
                }
            }
            throw new AssertionFailure("Unknown rewrite: " + rewriteMethod);
        }

        private static QueryParser.Operator toOperator(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    return QueryParser.Operator.AND;
                }
                case OR: {
                    return QueryParser.Operator.OR;
                }
            }
            throw new AssertionFailure("Unknown boolean operator: " + operator);
        }
    }
}

