/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.Set;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonQueryStringPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;

public class LuceneSimpleQueryStringPredicate
extends LuceneCommonQueryStringPredicate {
    private LuceneSimpleQueryStringPredicate(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends LuceneCommonQueryStringPredicate.Builder
    implements SimpleQueryStringPredicateBuilder {
        private int flags = -1;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void flags(Set<SimpleQueryFlag> flags) {
            this.flags = Builder.toFlagsMask(flags);
        }

        public SearchPredicate build() {
            return new LuceneSimpleQueryStringPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            SimpleQueryParser queryParser = new SimpleQueryParser(this.buildAnalyzer(), this.buildWeights(), this.flags);
            queryParser.setDefaultOperator(Builder.toOccur(this.defaultOperator));
            return this.applyMinimumShouldMatch(queryParser.parse(this.queryString));
        }

        @Override
        protected SearchQueryElementTypeKey<LuceneCommonQueryStringPredicateBuilderFieldState> typeKey() {
            return LucenePredicateTypeKeys.SIMPLE_QUERY_STRING;
        }

        private static BooleanClause.Occur toOccur(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    return BooleanClause.Occur.MUST;
                }
                case OR: {
                    return BooleanClause.Occur.SHOULD;
                }
            }
            throw new AssertionFailure("Unknown boolean operator: " + operator);
        }

        private static int toFlagsMask(Set<SimpleQueryFlag> flags) {
            int flag = -1;
            if (flags != null) {
                flag = 0;
                for (SimpleQueryFlag operation : flags) {
                    switch (operation) {
                        case AND: {
                            flag |= 1;
                            break;
                        }
                        case NOT: {
                            flag |= 2;
                            break;
                        }
                        case OR: {
                            flag |= 4;
                            break;
                        }
                        case PREFIX: {
                            flag |= 8;
                            break;
                        }
                        case PHRASE: {
                            flag |= 0x10;
                            break;
                        }
                        case PRECEDENCE: {
                            flag |= 0x20;
                            break;
                        }
                        case ESCAPE: {
                            flag |= 0x40;
                            break;
                        }
                        case WHITESPACE: {
                            flag |= 0x80;
                            break;
                        }
                        case FUZZY: {
                            flag |= 0x100;
                            break;
                        }
                        case NEAR: {
                            flag |= 0x200;
                        }
                    }
                }
            }
            return flag;
        }
    }
}

