/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.facet.impl;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;

public class TextMultiValueFacetCounts
extends Facets {
    final SortedSetDocValues dv;
    final String field;
    final int ordCount;
    final int[] counts;

    public TextMultiValueFacetCounts(IndexReader reader, String field, TextMultiValuesSource valuesSource, FacetsCollector hits) throws IOException {
        this.field = field;
        this.dv = MultiDocValues.getSortedSetValues((IndexReader)reader, (String)field);
        if (this.dv != null && this.dv.getValueCount() > Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot aggregate when more than 2147483647 terms are indexed");
        }
        this.ordCount = this.dv == null ? 0 : (int)this.dv.getValueCount();
        this.counts = new int[this.ordCount];
        this.count(reader, valuesSource, hits.getMatchingDocs());
    }

    public FacetResult getAllChildren(String dim, String ... path) {
        throw new UnsupportedOperationException("Getting all children is not supported by " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        return this.getTopChildrenSortByCount(topN);
    }

    private FacetResult getTopChildrenSortByCount(int topN) throws IOException {
        if (topN > this.ordCount) {
            topN = this.ordCount;
        }
        TopOrdAndIntQueue q = null;
        int bottomCount = 0;
        int totCount = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        for (int ord = 0; ord < this.ordCount; ++ord) {
            if (this.counts[ord] <= 0) continue;
            totCount += this.counts[ord];
            ++childCount;
            if (this.counts[ord] <= bottomCount) continue;
            if (reuse == null) {
                reuse = new TopOrdAndIntQueue.OrdAndValue();
            }
            reuse.ord = ord;
            reuse.value = this.counts[ord];
            if (q == null) {
                q = new TopOrdAndIntQueue(topN);
            }
            reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow((Object)reuse);
            if (q.size() != topN) continue;
            bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
        }
        if (q == null) {
            return null;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            BytesRef term = this.dv.lookupOrd((long)ordAndValue.ord);
            labelValues[i] = new LabelAndValue(term.utf8ToString(), (Number)ordAndValue.value);
        }
        return new FacetResult(this.field, new String[0], (Number)totCount, labelValues, childCount);
    }

    private void countOneSegment(OrdinalMap ordinalMap, TextMultiValues segValues, int segOrd, FacetsCollector.MatchingDocs hits) throws IOException {
        if (segValues == null) {
            return;
        }
        IntHashSet uniqueOrdinalsForDocument = new IntHashSet();
        DocIdSetIterator docs = hits.bits.iterator();
        if (ordinalMap != null) {
            LongValues ordMap = ordinalMap.getGlobalOrds(segOrd);
            int numSegOrds = (int)segValues.getValueCount();
            if (hits.totalHits < numSegOrds / 10) {
                IntProcedure incrementCountForOrdinal = ord -> {
                    int n = ord;
                    this.counts[n] = this.counts[n] + 1;
                };
                int doc = docs.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (segValues.advanceExact(doc)) {
                        while (segValues.hasNextValue()) {
                            int term = (int)segValues.nextOrd();
                            int globalOrd = (int)ordMap.get((long)term);
                            uniqueOrdinalsForDocument.add(globalOrd);
                        }
                        uniqueOrdinalsForDocument.forEach(incrementCountForOrdinal);
                        uniqueOrdinalsForDocument.clear();
                    }
                    doc = docs.nextDoc();
                }
            } else {
                int[] segCounts = new int[numSegOrds];
                IntProcedure incrementCountForOrdinal = ord -> {
                    int n = ord;
                    segCounts[n] = segCounts[n] + 1;
                };
                int doc = docs.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (segValues.advanceExact(doc)) {
                        while (segValues.hasNextValue()) {
                            int term = (int)segValues.nextOrd();
                            uniqueOrdinalsForDocument.add(term);
                        }
                        uniqueOrdinalsForDocument.forEach(incrementCountForOrdinal);
                        uniqueOrdinalsForDocument.clear();
                    }
                    doc = docs.nextDoc();
                }
                for (int ord2 = 0; ord2 < numSegOrds; ++ord2) {
                    int count = segCounts[ord2];
                    if (count == 0) continue;
                    int n = (int)ordMap.get((long)ord2);
                    this.counts[n] = this.counts[n] + count;
                }
            }
        } else {
            IntProcedure incrementCountForOrdinal = ord -> {
                int n = ord;
                this.counts[n] = this.counts[n] + 1;
            };
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (segValues.advanceExact(doc)) {
                    while (segValues.hasNextValue()) {
                        int term = (int)segValues.nextOrd();
                        uniqueOrdinalsForDocument.add(term);
                    }
                    uniqueOrdinalsForDocument.forEach(incrementCountForOrdinal);
                    uniqueOrdinalsForDocument.clear();
                }
                doc = docs.nextDoc();
            }
        }
    }

    private void count(IndexReader reader, TextMultiValuesSource valuesSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues && matchingDocs.size() > 1 ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (ReaderUtil.getTopLevelContext((IndexReaderContext)hits.context).reader() != reader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            this.countOneSegment(ordinalMap, valuesSource.getValues(hits.context), hits.context.ord, hits);
        }
    }

    public Number getSpecificValue(String dim, String ... path) {
        throw new UnsupportedOperationException();
    }

    public List<FacetResult> getAllDims(int topN) throws IOException {
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }
}

