/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.backend.analysis.AnalysisToken;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneAnalysisPerformer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneBackend backend;

    public LuceneAnalysisPerformer(LuceneBackend backend) {
        this.backend = backend;
    }

    public List<? extends AnalysisToken> analyze(String analyzerName, String terms) {
        Analyzer analyzer = this.backend.analyzer(analyzerName).orElseThrow(() -> log.noSuchAnalyzer(analyzerName));
        return LuceneAnalysisPerformer.analyze(analyzerName, analyzer, terms);
    }

    public AnalysisToken normalize(String normalizerName, String terms) {
        Analyzer analyzer = this.backend.normalizer(normalizerName).orElseThrow(() -> log.noSuchNormalizer(normalizerName));
        List<LuceneAnalysisToken> tokens = LuceneAnalysisPerformer.analyze(normalizerName, analyzer, terms);
        if (tokens.size() != 1) {
            throw new AssertionFailure("Applying an normalizer to a string should have produced a single token. Instead applying " + normalizerName + " to '" + terms + "' produced: " + tokens);
        }
        return tokens.get(0);
    }

    private static List<LuceneAnalysisToken> analyze(String analyzerName, Analyzer analyzer, String string) {
        ArrayList<LuceneAnalysisToken> tokens = new ArrayList<LuceneAnalysisToken>();
        try (TokenStream tokenStream = analyzer.tokenStream("", string);){
            CharTermAttribute termAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
            TypeAttribute typeAttribute = (TypeAttribute)tokenStream.addAttribute(TypeAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                tokens.add(new LuceneAnalysisToken(termAttribute.toString(), offsetAttribute.startOffset(), offsetAttribute.endOffset(), typeAttribute.type()));
            }
        }
        catch (IOException e) {
            throw log.unableToPerformAnalysisOperation(analyzerName, string, e.getMessage(), e);
        }
        return tokens;
    }

    private static class LuceneAnalysisToken
    implements AnalysisToken {
        private final String term;
        private final int startOffset;
        private final int endOffset;
        private final String type;

        private LuceneAnalysisToken(String term, int startOffset, int endOffset, String type) {
            this.term = term;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
        }

        public String term() {
            return this.term;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public String type() {
            return this.type;
        }

        public String toString() {
            return "AnalysisToken{value='" + this.term + "', startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", type='" + this.type + "'}";
        }
    }
}

