/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonQueryStringPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.QueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneQueryStringPredicate
extends LuceneCommonQueryStringPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneQueryStringPredicate(Builder builder) {
        super(builder);
    }

    private static class HibernateSearchMultiFieldQueryParser
    extends MultiFieldQueryParser {
        private final Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates;
        private final LuceneSearchIndexScope<?> scope;

        public HibernateSearchMultiFieldQueryParser(Analyzer analyzer, Map<String, Float> boosts, Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates, LuceneSearchIndexScope<?> scope) {
            super((String[])boosts.keySet().toArray(String[]::new), analyzer, boosts);
            this.fieldStates = fieldStates;
            this.scope = scope;
        }

        protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
            LuceneCommonQueryStringPredicateBuilderFieldState state = this.fieldStates.get(field);
            if (!state.field().type().valueClass().isAssignableFrom(String.class)) {
                MatchPredicateBuilder builder = (MatchPredicateBuilder)state.field().queryElement(PredicateTypeKeys.MATCH, this.scope);
                builder.value((Object)queryText, ValueConvert.PARSE);
                return LuceneSearchPredicate.from(this.scope, builder.build()).toQuery(LuceneCommonQueryStringPredicate.contextForField(state));
            }
            return super.newFieldQuery(analyzer, field, queryText, quoted);
        }

        protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
            LuceneCommonQueryStringPredicate.checkFieldsAreAcceptable("Fuzzy", this.fieldStates);
            return super.getFuzzyQuery(field, termStr, minSimilarity);
        }

        protected Query getPrefixQuery(String field, String termStr) throws ParseException {
            LuceneCommonQueryStringPredicate.checkFieldsAreAcceptable("Prefix", this.fieldStates);
            return super.getPrefixQuery(field, termStr);
        }

        protected Query getRegexpQuery(String field, String termStr) throws ParseException {
            LuceneCommonQueryStringPredicate.checkFieldsAreAcceptable("Regexp", this.fieldStates);
            return super.getRegexpQuery(field, termStr);
        }

        protected Query getWildcardQuery(String field, String termStr) throws ParseException {
            LuceneCommonQueryStringPredicate.checkFieldsAreAcceptable("Wildcard", this.fieldStates);
            return super.getWildcardQuery(field, termStr);
        }

        protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
            LuceneCommonQueryStringPredicateBuilderFieldState state = this.fieldStates.get(field);
            if (!state.field().type().valueClass().isAssignableFrom(String.class)) {
                RangePredicateBuilder builder = (RangePredicateBuilder)state.field().queryElement(PredicateTypeKeys.RANGE, this.scope);
                builder.range(Range.between((Object)part1, (RangeBoundInclusion)(startInclusive ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED), (Object)part2, (RangeBoundInclusion)(endInclusive ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED)), ValueConvert.PARSE, ValueConvert.PARSE);
                return LuceneSearchPredicate.from(this.scope, builder.build()).toQuery(LuceneCommonQueryStringPredicate.contextForField(state));
            }
            return super.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
        }
    }

    public static class Builder
    extends LuceneCommonQueryStringPredicate.Builder
    implements QueryStringPredicateBuilder {
        private Boolean allowLeadingWildcard = true;
        private Boolean enablePositionIncrements = true;
        private Integer phraseSlop;
        private RewriteMethod rewriteMethod;
        private Integer rewriteN;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void allowLeadingWildcard(boolean allowLeadingWildcard) {
            this.allowLeadingWildcard = allowLeadingWildcard;
        }

        public void enablePositionIncrements(boolean enablePositionIncrements) {
            this.enablePositionIncrements = enablePositionIncrements;
        }

        public void phraseSlop(Integer phraseSlop) {
            this.phraseSlop = phraseSlop;
        }

        public void rewriteMethod(RewriteMethod rewriteMethod, Integer n) {
            this.rewriteMethod = rewriteMethod;
            this.rewriteN = n;
        }

        public SearchPredicate build() {
            return new LuceneQueryStringPredicate(this);
        }

        @Override
        protected SearchQueryElementTypeKey<LuceneCommonQueryStringPredicateBuilderFieldState> typeKey() {
            return LucenePredicateTypeKeys.QUERY_STRING;
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            if (this.queryString == null || this.queryString.trim().isEmpty()) {
                return new MatchNoDocsQuery();
            }
            MultiFieldQueryParser queryParser = this.create(this.buildWeights(), this.buildAnalyzer(), this.fieldStateLookup());
            queryParser.setDefaultOperator(Builder.toOperator(this.defaultOperator));
            if (this.rewriteMethod != null) {
                queryParser.setMultiTermRewriteMethod(this.toRewriteMethod(this.rewriteMethod, this.rewriteN));
            }
            if (this.allowLeadingWildcard != null) {
                queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard.booleanValue());
            }
            if (this.enablePositionIncrements != null) {
                queryParser.setEnablePositionIncrements(this.enablePositionIncrements.booleanValue());
            }
            if (this.phraseSlop != null) {
                queryParser.setPhraseSlop(this.phraseSlop.intValue());
            }
            try {
                return this.addMatchAllForBoolMustNotOnly(this.minimumShouldMatchConstraints.apply(queryParser.parse(this.queryString)));
            }
            catch (ParseException e) {
                throw log.queryStringParseException(this.queryString, e.getMessage(), (Exception)((Object)e));
            }
        }

        private MultiFieldQueryParser create(Map<String, Float> weights, Analyzer analyzer, Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStateMap) {
            return new HibernateSearchMultiFieldQueryParser(analyzer, weights, fieldStateMap, this.scope);
        }

        private MultiTermQuery.RewriteMethod toRewriteMethod(RewriteMethod rewriteMethod, Integer n) {
            switch (rewriteMethod) {
                case CONSTANT_SCORE: {
                    return MultiTermQuery.CONSTANT_SCORE_REWRITE;
                }
                case CONSTANT_SCORE_BOOLEAN: {
                    return MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE;
                }
                case SCORING_BOOLEAN: {
                    return MultiTermQuery.SCORING_BOOLEAN_REWRITE;
                }
                case TOP_TERMS_BLENDED_FREQS_N: {
                    return new MultiTermQuery.TopTermsBlendedFreqScoringRewrite(n.intValue());
                }
                case TOP_TERMS_BOOST_N: {
                    return new MultiTermQuery.TopTermsBoostOnlyBooleanQueryRewrite(n.intValue());
                }
                case TOP_TERMS_N: {
                    return new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(n.intValue());
                }
            }
            throw new AssertionFailure("Unknown rewrite: " + rewriteMethod);
        }

        private static QueryParser.Operator toOperator(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    return QueryParser.Operator.AND;
                }
                case OR: {
                    return QueryParser.Operator.OR;
                }
            }
            throw new AssertionFailure("Unknown boolean operator: " + operator);
        }
    }
}

