/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonQueryStringPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;

public class LuceneSimpleQueryStringPredicate
extends LuceneCommonQueryStringPredicate {
    private LuceneSimpleQueryStringPredicate(Builder builder) {
        super(builder);
    }

    private static class HibernateSearchSimpleQueryParser
    extends SimpleQueryParser {
        private final Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates;
        private final LuceneSearchIndexScope<?> scope;

        public HibernateSearchSimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates, int flags, LuceneSearchIndexScope<?> scope) {
            super(analyzer, weights, flags);
            this.fieldStates = fieldStates;
            this.scope = scope;
        }

        protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
            LuceneCommonQueryStringPredicateBuilderFieldState state = this.fieldStates.get(field);
            if (!state.field().type().valueClass().isAssignableFrom(String.class)) {
                MatchPredicateBuilder builder = (MatchPredicateBuilder)state.field().queryElement(PredicateTypeKeys.MATCH, this.scope);
                builder.value((Object)queryText, ValueConvert.PARSE);
                return LuceneSearchPredicate.from(this.scope, builder.build()).toQuery(LuceneCommonQueryStringPredicate.contextForField(state));
            }
            return super.createFieldQuery(analyzer, operator, field, queryText, quoted, phraseSlop);
        }

        protected Query newPrefixQuery(String text) {
            LuceneCommonQueryStringPredicate.checkFieldsAreAcceptable("Prefix", this.fieldStates);
            return super.newPrefixQuery(text);
        }

        protected Query newFuzzyQuery(String text, int fuzziness) {
            LuceneCommonQueryStringPredicate.checkFieldsAreAcceptable("Fuzzy", this.fieldStates);
            return super.newFuzzyQuery(text, fuzziness);
        }
    }

    public static class Builder
    extends LuceneCommonQueryStringPredicate.Builder
    implements SimpleQueryStringPredicateBuilder {
        private int flags = -1;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void flags(Set<SimpleQueryFlag> flags) {
            this.flags = Builder.toFlagsMask(flags);
        }

        public SearchPredicate build() {
            return new LuceneSimpleQueryStringPredicate(this);
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            HibernateSearchSimpleQueryParser queryParser = new HibernateSearchSimpleQueryParser(this.buildAnalyzer(), this.buildWeights(), this.fieldStateLookup(), this.flags, this.scope);
            queryParser.setDefaultOperator(Builder.toOccur(this.defaultOperator));
            return this.minimumShouldMatchConstraints.apply(queryParser.parse(this.queryString));
        }

        @Override
        protected SearchQueryElementTypeKey<LuceneCommonQueryStringPredicateBuilderFieldState> typeKey() {
            return LucenePredicateTypeKeys.SIMPLE_QUERY_STRING;
        }

        private static BooleanClause.Occur toOccur(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    return BooleanClause.Occur.MUST;
                }
                case OR: {
                    return BooleanClause.Occur.SHOULD;
                }
            }
            throw new AssertionFailure("Unknown boolean operator: " + operator);
        }

        private static int toFlagsMask(Set<SimpleQueryFlag> flags) {
            int flag = -1;
            if (flags != null) {
                flag = 0;
                for (SimpleQueryFlag operation : flags) {
                    switch (operation) {
                        case AND: {
                            flag |= 1;
                            break;
                        }
                        case NOT: {
                            flag |= 2;
                            break;
                        }
                        case OR: {
                            flag |= 4;
                            break;
                        }
                        case PREFIX: {
                            flag |= 8;
                            break;
                        }
                        case PHRASE: {
                            flag |= 0x10;
                            break;
                        }
                        case PRECEDENCE: {
                            flag |= 0x20;
                            break;
                        }
                        case ESCAPE: {
                            flag |= 0x40;
                            break;
                        }
                        case WHITESPACE: {
                            flag |= 0x80;
                            break;
                        }
                        case FUZZY: {
                            flag |= 0x100;
                            break;
                        }
                        case NEAR: {
                            flag |= 0x200;
                        }
                    }
                }
            }
            return flag;
        }
    }
}

