/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.FromDocumentValueConvertContextImpl;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneExtractableSearchResult<H> {
    private final LuceneSearchQueryRequestContext requestContext;
    private final FromDocumentValueConvertContext fromDocumentValueConvertContext;
    private final IndexSearcher indexSearcher;
    private final LuceneCollectors luceneCollectors;
    private final LuceneSearchProjection.Extractor<?, H> rootExtractor;
    private final Map<AggregationKey<?>, LuceneSearchAggregation.Extractor<?>> aggregations;
    private final TimeoutManager timeoutManager;

    LuceneExtractableSearchResult(LuceneSearchQueryRequestContext requestContext, IndexSearcher indexSearcher, LuceneCollectors luceneCollectors, LuceneSearchProjection.Extractor<?, H> rootExtractor, Map<AggregationKey<?>, LuceneSearchAggregation.Extractor<?>> aggregations, TimeoutManager timeoutManager) {
        this.requestContext = requestContext;
        this.fromDocumentValueConvertContext = new FromDocumentValueConvertContextImpl(requestContext.getSessionContext());
        this.indexSearcher = indexSearcher;
        this.luceneCollectors = luceneCollectors;
        this.rootExtractor = rootExtractor;
        this.aggregations = aggregations;
        this.timeoutManager = timeoutManager;
    }

    public LuceneLoadableSearchResult<H> extract() throws IOException {
        return this.extract(0, Integer.MAX_VALUE);
    }

    public LuceneLoadableSearchResult<H> extract(int startInclusive, int endExclusive) throws IOException {
        TopDocs topDocs = this.luceneCollectors.getTopDocs();
        if (topDocs == null) {
            startInclusive = 0;
            endExclusive = 0;
        } else {
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            startInclusive = Math.min(startInclusive, scoreDocs.length);
            endExclusive = Math.min(endExclusive, scoreDocs.length);
        }
        ProjectionHitMapper projectionHitMapper = this.requestContext.getLoadingContext().createProjectionHitMapper();
        List<Object> extractedData = this.extractHits(projectionHitMapper, startInclusive, endExclusive);
        Map<Object, Object> extractedAggregations = this.aggregations.isEmpty() ? Collections.emptyMap() : this.extractAggregations();
        return new LuceneLoadableSearchResult<H>(this.fromDocumentValueConvertContext, this.rootExtractor, this.luceneCollectors.getResultTotal(), this.luceneCollectors.getTopDocs(), extractedData, extractedAggregations, projectionHitMapper, this.timeoutManager.tookTime(), this.timeoutManager.isTimedOut(), this.timeoutManager);
    }

    public int hitSize() {
        TopDocs topDocs = this.luceneCollectors.getTopDocs();
        return topDocs == null ? 0 : topDocs.scoreDocs.length;
    }

    SearchResultTotal total() {
        return this.luceneCollectors.getResultTotal();
    }

    private List<Object> extractHits(ProjectionHitMapper<?> projectionHitMapper, int startInclusive, int endExclusive) throws IOException {
        TopDocs topDocs = this.luceneCollectors.getTopDocs();
        if (topDocs == null) {
            return Collections.emptyList();
        }
        TopDocsDataCollectorFactory collectorFactory = new TopDocsDataCollectorFactory(projectionHitMapper);
        return this.luceneCollectors.collectTopDocsData(collectorFactory, startInclusive, endExclusive);
    }

    private Map<AggregationKey<?>, ?> extractAggregations() throws IOException {
        AggregationExtractContext aggregationExtractContext = new AggregationExtractContext(this.requestContext.getQueryIndexScope(), this.requestContext.getSessionContext(), this.indexSearcher.getIndexReader(), this.fromDocumentValueConvertContext, this.luceneCollectors.collectedMultiResults(), this.requestContext.getRoutingKeys(), this.requestContext.getQueryParameters());
        LinkedHashMap extractedMap = new LinkedHashMap();
        for (Map.Entry<AggregationKey<?>, LuceneSearchAggregation.Extractor<?>> entry : this.aggregations.entrySet()) {
            if (this.timeoutManager.checkTimedOut()) break;
            AggregationKey<?> key = entry.getKey();
            LuceneSearchAggregation.Extractor<?> aggregation = entry.getValue();
            Object extracted = aggregation.extract(aggregationExtractContext);
            extractedMap.put(key, extracted);
        }
        return extractedMap;
    }

    private class TopDocsDataCollectorFactory
    implements TopDocsDataCollector.Factory<Object> {
        private final ProjectionHitMapper<?> projectionHitMapper;

        public TopDocsDataCollectorFactory(ProjectionHitMapper<?> projectionHitMapper) {
            this.projectionHitMapper = projectionHitMapper;
        }

        @Override
        public CollectorManager<TopDocsDataCollector<Object>, IntObjectMap<Object>> create(final TopDocsDataCollectorExecutionContext context) {
            final ProjectionExtractContext projectionExtractContext = new ProjectionExtractContext(context, this.projectionHitMapper);
            return new CollectorManager<TopDocsDataCollector<Object>, IntObjectMap<Object>>(){

                public TopDocsDataCollector<Object> newCollector() {
                    return new TopDocsDataCollector<Object>(context, LuceneExtractableSearchResult.this.rootExtractor.values(projectionExtractContext));
                }

                public IntObjectMap<Object> reduce(Collection<TopDocsDataCollector<Object>> collectors) {
                    if (collectors.size() == 1) {
                        return collectors.iterator().next().collected();
                    }
                    IntObjectHashMap combined = new IntObjectHashMap();
                    for (TopDocsDataCollector<Object> collector : collectors) {
                        combined.putAll(collector.collected());
                    }
                    return combined;
                }
            };
        }
    }
}

