/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.FacetsCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneBucketAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.Bucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.BucketOrder;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;

public abstract class AbstractLuceneFacetsBasedTermsAggregation<F, T, K>
extends AbstractLuceneBucketAggregation<K, Long> {
    private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;
    private final BucketOrder order;
    private final int maxTermCount;
    private final int minDocCount;

    AbstractLuceneFacetsBasedTermsAggregation(AbstractBuilder<F, T, K> builder) {
        super(builder);
        this.fromFieldValueConverter = builder.fromFieldValueConverter;
        this.order = builder.order;
        this.maxTermCount = builder.maxTermCount;
        this.minDocCount = builder.minDocCount;
    }

    @Override
    public LuceneSearchAggregation.Extractor<Map<K, Long>> request(AggregationRequestContext context) {
        context.requireCollector(FacetsCollectorFactory.INSTANCE);
        return this.extractor(context);
    }

    protected abstract LuceneSearchAggregation.Extractor<Map<K, Long>> extractor(AggregationRequestContext var1);

    static abstract class AbstractBuilder<F, T, K>
    extends AbstractLuceneBucketAggregation.AbstractBuilder<K, Long>
    implements TermsAggregationBuilder<K> {
        private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;
        private BucketOrder order = BucketOrder.COUNT_DESC;
        private int minDocCount = 1;
        private int maxTermCount = 100;

        AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, ProjectionConverter<F, ? extends K> fromFieldValueConverter) {
            super(scope, field);
            this.fromFieldValueConverter = fromFieldValueConverter;
        }

        public void orderByCountDescending() {
            this.order(BucketOrder.COUNT_DESC);
        }

        public void orderByCountAscending() {
            this.order(BucketOrder.COUNT_ASC);
        }

        public void orderByTermAscending() {
            this.order(BucketOrder.TERM_ASC);
        }

        public void orderByTermDescending() {
            this.order(BucketOrder.TERM_DESC);
        }

        public void minDocumentCount(int minDocumentCount) {
            this.minDocCount = minDocumentCount;
        }

        public void maxTermCount(int maxTermCount) {
            this.maxTermCount = maxTermCount;
        }

        @Override
        public abstract AbstractLuceneFacetsBasedTermsAggregation<F, T, K> build();

        protected final void order(BucketOrder order) {
            this.order = order;
        }
    }

    static abstract class AbstractTypeSelector<F>
    implements TermsAggregationBuilder.TypeSelector {
        protected final LuceneSearchIndexScope<?> scope;
        protected final LuceneSearchIndexValueFieldContext<F> field;

        protected AbstractTypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.scope = scope;
            this.field = field;
        }

        public abstract <K> AbstractBuilder<F, ?, K> type(Class<K> var1, ValueConvert var2);
    }

    protected abstract class AbstractExtractor
    implements LuceneSearchAggregation.Extractor<Map<K, Long>> {
        protected AbstractExtractor() {
        }

        @Override
        public final Map<K, Long> extract(AggregationExtractContext context) throws IOException {
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            List buckets = this.getTopBuckets(context);
            if (BucketOrder.COUNT_DESC.equals((Object)AbstractLuceneFacetsBasedTermsAggregation.this.order) && (AbstractLuceneFacetsBasedTermsAggregation.this.minDocCount > 0 || buckets.size() >= AbstractLuceneFacetsBasedTermsAggregation.this.maxTermCount)) {
                return this.toMap(convertContext, buckets);
            }
            if (AbstractLuceneFacetsBasedTermsAggregation.this.minDocCount <= 0) {
                Set firstTerms = this.collectFirstTerms(context.getIndexReader(), AbstractLuceneFacetsBasedTermsAggregation.this.order.isTermOrderDescending(), AbstractLuceneFacetsBasedTermsAggregation.this.maxTermCount);
                for (Bucket bucket : buckets) {
                    firstTerms.remove(bucket.term);
                }
                for (Bucket term : firstTerms) {
                    buckets.add(new Bucket(term, 0L));
                }
            }
            buckets.sort(AbstractLuceneFacetsBasedTermsAggregation.this.order.toBucketComparator(this.getAscendingTermComparator()));
            if (buckets.size() > AbstractLuceneFacetsBasedTermsAggregation.this.maxTermCount) {
                buckets.subList(AbstractLuceneFacetsBasedTermsAggregation.this.maxTermCount, buckets.size()).clear();
            }
            return this.toMap(convertContext, buckets);
        }

        abstract FacetResult getTopChildren(IndexReader var1, FacetsCollector var2, NestedDocsProvider var3, int var4) throws IOException;

        abstract Set<T> collectFirstTerms(IndexReader var1, boolean var2, int var3) throws IOException;

        abstract Comparator<T> getAscendingTermComparator();

        abstract T labelToTerm(String var1);

        abstract F termToFieldValue(T var1);

        private List<Bucket<T>> getTopBuckets(AggregationExtractContext context) throws IOException {
            FacetsCollector facetsCollector = context.getFacets(FacetsCollectorFactory.KEY);
            NestedDocsProvider nestedDocsProvider = AbstractLuceneFacetsBasedTermsAggregation.this.createNestedDocsProvider(context);
            int limit = AbstractLuceneFacetsBasedTermsAggregation.this.maxTermCount;
            FacetResult facetResult = this.getTopChildren(context.getIndexReader(), facetsCollector, nestedDocsProvider, limit);
            ArrayList buckets = new ArrayList();
            if (facetResult != null) {
                for (LabelAndValue labelAndValue : facetResult.labelValues) {
                    long count = ((Integer)labelAndValue.value).intValue();
                    if (count < (long)AbstractLuceneFacetsBasedTermsAggregation.this.minDocCount) continue;
                    buckets.add(new Bucket(this.labelToTerm(labelAndValue.label), count));
                }
            }
            return buckets;
        }

        private Map<K, Long> toMap(FromDocumentValueConvertContext convertContext, List<Bucket<T>> buckets) {
            LinkedHashMap<Object, Long> result = new LinkedHashMap<Object, Long>();
            for (Bucket bucket : buckets) {
                Object decoded = this.termToFieldValue(bucket.term);
                Object key = AbstractLuceneFacetsBasedTermsAggregation.this.fromFieldValueConverter.fromDocumentValue(decoded, convertContext);
                result.put(key, bucket.count);
            }
            return result;
        }
    }
}

