/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.TermsPredicateBuilder;

public class LuceneTextTermsPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneTextTermsPredicate(Builder<?> builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements TermsPredicateBuilder {
        private final LuceneStandardFieldCodec<F, String> codec;
        private String term;
        private List<String> terms;
        private boolean allMatch;

        private Builder(LuceneStandardFieldCodec<F, String> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.constantScore();
            this.codec = codec;
        }

        public void matchingAny(Collection<?> terms, ValueConvert convert) {
            this.allMatch = false;
            this.fillTerms(terms, convert);
        }

        public void matchingAll(Collection<?> terms, ValueConvert convert) {
            this.allMatch = true;
            this.fillTerms(terms, convert);
        }

        public SearchPredicate build() {
            return new LuceneTextTermsPredicate(this);
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            if (this.term != null) {
                return new TermQuery(new Term(this.absoluteFieldPath, this.term));
            }
            if (!this.allMatch) {
                List bytesRefs = this.terms.stream().map(BytesRef::new).collect(Collectors.toList());
                return new TermInSetQuery(this.absoluteFieldPath, bytesRefs);
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (String termItem : this.terms) {
                TermQuery query = new TermQuery(new Term(this.absoluteFieldPath, termItem));
                builder.add((Query)query, BooleanClause.Occur.MUST);
            }
            return builder.build();
        }

        private void fillTerms(Collection<?> terms, ValueConvert convert) {
            if (terms.size() == 1) {
                this.term = this.convertAndEncode(this.codec, terms.iterator().next(), convert);
                this.terms = null;
                return;
            }
            this.term = null;
            this.terms = new ArrayList<String>(terms.size());
            for (Object termItem : terms) {
                this.terms.add(this.convertAndEncode(this.codec, termItem, convert));
            }
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<TermsPredicateBuilder, F, LuceneStandardFieldCodec<F, String>> {
        public Factory(LuceneStandardFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public Builder<F> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder<F>((LuceneStandardFieldCodec)this.codec, scope, field);
        }
    }
}

