/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.backend.lucene.logging.impl.AnalysisLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class AnalysisLog_$logger
implements AnalysisLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AnalysisLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public AnalysisLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Unable to apply analysis configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, String value1, String value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void normalizerProducedMultipleTokens(String normalizerName, int token) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.normalizerProducedMultipleTokens$str(), (Object)normalizerName, (Object)token);
    }

    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: Invalid normalizer implementation: the normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }

    @Override
    public final SearchException unknownAnalyzer(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzer$str(), analyzerName), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToCreateAnalyzer(String name, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalyzer$str(), name, causeMessage), (Throwable)e);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToCreateNormalizer(String name, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateNormalizer$str(), name, causeMessage), (Throwable)e);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }

    @Override
    public final SearchException unknownNormalizer(String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNormalizer$str(), normalizerName), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }

    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(String searchAnalyzer, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAnalysisComponent$str() {
        return "HSEARCH600142: Unable to create instance of analysis component '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToCreateAnalysisComponent(Class<?> type, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalysisComponent$str(), new ClassFormatter(type), causeMessage), (Throwable)cause);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSuchAnalyzer$str() {
        return "HSEARCH600181: An analyzer '%1$s' cannot be found.";
    }

    @Override
    public final SearchException noSuchAnalyzer(String analyzer) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noSuchAnalyzer$str(), analyzer));
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSuchNormalizer$str() {
        return "HSEARCH600182: A normalizer '%1$s' cannot be found.";
    }

    @Override
    public final SearchException noSuchNormalizer(String normalizer) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noSuchNormalizer$str(), normalizer));
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToPerformAnalysisOperation$str() {
        return "HSEARCH600183: Failed to apply '%1$s' to '%2$s': '%3$s'";
    }

    @Override
    public final SearchException unableToPerformAnalysisOperation(String analyzerName, String string, String reason, IOException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToPerformAnalysisOperation$str(), analyzerName, string, reason), (Throwable)cause);
        AnalysisLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

