/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.logging.impl.ConfigurationLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class ConfigurationLog_$logger
extends DelegatingBasicLogger
implements ConfigurationLog,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ConfigurationLog_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void recommendConfiguringLuceneVersion(String key, Version latest, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), (Object)key, (Object)latest, (Object)new EventContextFormatter(context));
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Missing value for configuration property '%1$s': using LATEST (currently '%2$s'). %3$s";
    }

    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Unable to parse '%1$ss' into a Lucene version: %2$s";
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String property, String luceneErrorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalLuceneVersionFormat$str(), property, luceneErrorMessage), (Throwable)e);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(Set<String> tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidFileSystemAccessStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidLockingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: Incorrect sharding strategy implementation: strategy '%1$s' did not declare any shard identifiers during initialization. Declare shard identifiers using context.shardIdentifiers(...) or, if sharding is disabled, call context.disableSharding().";
    }

    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object strategy) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: When using sharding strategy '%1$s', this configuration property must be set.";
    }

    @Override
    public final SearchException missingPropertyValueForShardingStrategy(String strategyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyValueForShardingStrategy$str(), strategyName));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }

    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(String invalidKey, Collection<String> validKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidIOStrategyName$str() {
        return "HSEARCH600108: Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidIOStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIOStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalIndexWriterSetting$str() {
        return "HSEARCH600123: Invalid value for IndexWriter setting '%1$s': '%2$s'. %3$s";
    }

    @Override
    public final SearchException illegalIndexWriterSetting(String settingName, Object settingValue, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalIndexWriterSetting$str(), settingName, settingValue, message), (Throwable)e);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalMergePolicySetting$str() {
        return "HSEARCH600124: Invalid value for merge policy setting '%1$s': '%2$s'. %3$s";
    }

    @Override
    public final SearchException illegalMergePolicySetting(String settingName, Object settingValue, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalMergePolicySetting$str(), settingName, settingValue, message), (Throwable)e);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToApplyQueryCacheConfiguration$str() {
        return "HSEARCH600146: Unable to apply query caching configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyQueryCacheConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyQueryCacheConfiguration$str(), errorMessage), (Throwable)e);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH600148: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButExplicitlyDisabledByBackend$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH600149: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void luceneCompatibilityVersion(Version luceneVersion) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.luceneCompatibilityVersion$str(), (Object)luceneVersion);
    }

    protected String luceneCompatibilityVersion$str() {
        return "HSEARCH600188: Setting Lucene compatibility to Version %s";
    }
}

