/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchScroll;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneExtractableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchScrollImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.impl.Contracts;

public class LuceneSearchQueryImpl<H>
extends AbstractSearchQuery<H, LuceneSearchResult<H>>
implements LuceneSearchQuery<H> {
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneWorkFactory workFactory;
    private final LuceneSearchQueryIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final SearchLoadingContext<?> loadingContext;
    private final Set<String> routingKeys;
    private final Query luceneQuery;
    private final Sort luceneSort;
    private final LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> searcher;
    private final Long totalHitCountThreshold;
    private TimeoutManager timeoutManager;

    LuceneSearchQueryImpl(LuceneSyncWorkOrchestrator queryOrchestrator, LuceneWorkFactory workFactory, LuceneSearchQueryIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContext<?> loadingContext, Set<String> routingKeys, TimeoutManager timeoutManager, Query luceneQuery, Sort luceneSort, LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> searcher, Long totalHitCountThreshold) {
        this.queryOrchestrator = queryOrchestrator;
        this.workFactory = workFactory;
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.routingKeys = routingKeys;
        this.timeoutManager = timeoutManager;
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
        this.searcher = searcher;
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    public String queryString() {
        return this.luceneQuery.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[searcher=" + String.valueOf(this.searcher) + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public LuceneSearchResult<H> fetch(Integer offset, Integer limit) {
        return this.doFetch(offset, limit, true);
    }

    public List<H> fetchHits(Integer offset, Integer limit) {
        return this.doFetch(offset, limit, false).hits();
    }

    public long fetchTotalHitCount() {
        this.timeoutManager.start();
        ReadWork<Integer> work = this.workFactory.count(this.searcher);
        Integer result = this.doSubmit(work);
        this.timeoutManager.stop();
        return result.intValue();
    }

    public LuceneSearchScroll<H> scroll(int chunkSize) {
        Set indexNames = this.scope.hibernateSearchIndexNames();
        HibernateSearchMultiReader indexReader = HibernateSearchMultiReader.open(indexNames, this.scope.indexes(), this.routingKeys);
        return new LuceneSearchScrollImpl<H>(this.queryOrchestrator, this.workFactory, this.scope, this.routingKeys, this.timeoutManager, this.searcher, this.totalHitCountThreshold(true), indexReader, chunkSize);
    }

    @Override
    public Explanation explain(Object id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, LuceneSearchIndexContext> mappedTypeNameToIndex = this.scope.mappedTypeNameToIndex();
        if (mappedTypeNameToIndex.size() != 1) {
            throw QueryLog.INSTANCE.explainRequiresTypeName(mappedTypeNameToIndex.keySet());
        }
        Map.Entry<String, LuceneSearchIndexContext> entry = mappedTypeNameToIndex.entrySet().iterator().next();
        String typeName = entry.getKey();
        LuceneSearchIndexContext index = entry.getValue();
        String documentId = this.toDocumentId(index, id);
        return this.doExplain(typeName, documentId);
    }

    @Override
    public Explanation explain(String typeName, Object id) {
        Contracts.assertNotNull((Object)typeName, (String)"typeName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, LuceneSearchIndexContext> mappedTypeNameToIndex = this.scope.mappedTypeNameToIndex();
        LuceneSearchIndexContext index = mappedTypeNameToIndex.get(typeName);
        if (!mappedTypeNameToIndex.containsKey(typeName)) {
            throw QueryLog.INSTANCE.explainRequiresTypeTargetedByQuery(mappedTypeNameToIndex.keySet(), typeName);
        }
        String documentId = this.toDocumentId(index, id);
        return this.doExplain(typeName, documentId);
    }

    @Override
    public Sort luceneSort() {
        return this.luceneSort;
    }

    public void failAfter(Long timeout, TimeUnit timeUnit) {
        this.timeoutManager = this.scope.createTimeoutManager(timeout, timeUnit, true);
        this.searcher.setTimeoutManager(this.timeoutManager);
    }

    private LuceneSearchResult<H> doFetch(Integer offset, Integer limit, boolean trackTotalHitCount) {
        this.timeoutManager.start();
        ReadWork<LuceneLoadableSearchResult<H>> work = this.workFactory.search(this.searcher, offset, limit, this.totalHitCountThreshold(trackTotalHitCount));
        LuceneSearchResult<H> result = this.doSubmit(work).loadBlocking();
        this.timeoutManager.stop();
        return result;
    }

    private Explanation doExplain(String typeName, String id) {
        this.timeoutManager.start();
        Query filter = this.scope.filterOrNull(this.sessionContext.tenantIdentifier());
        ReadWork<Explanation> work = this.workFactory.explain(this.searcher, typeName, id, filter);
        Explanation explanation = this.doSubmit(work);
        this.timeoutManager.stop();
        return explanation;
    }

    private <T> T doSubmit(ReadWork<T> work) {
        return this.queryOrchestrator.submit(this.scope.hibernateSearchIndexNames(), this.scope.indexes(), this.routingKeys, work);
    }

    private int totalHitCountThreshold(boolean trackTotalHitCount) {
        if (!trackTotalHitCount) {
            return 0;
        }
        if (this.totalHitCountThreshold == null || this.totalHitCountThreshold >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Math.toIntExact(this.totalHitCountThreshold);
    }

    private String toDocumentId(LuceneSearchIndexContext index, Object id) {
        DslConverter converter = index.identifier().mappingDslConverter();
        ToDocumentValueConvertContext context = this.scope.toDocumentValueConvertContext();
        return (String)converter.unknownTypeToDocumentValue(id, context);
    }
}

