/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.Comparator;
import org.hibernate.search.backend.lucene.types.aggregation.impl.Bucket;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum BucketOrder {
    COUNT_ASC{

        @Override
        <F> Comparator<Bucket<F>> toBucketComparatorInternal(Comparator<F> termComparator) {
            return (left, right) -> {
                int order = Long.compare(left.count, right.count);
                if (order != 0) {
                    return order;
                }
                order = termComparator.compare(left.term, right.term);
                return order;
            };
        }
    }
    ,
    COUNT_DESC{

        @Override
        <F> Comparator<Bucket<F>> toBucketComparatorInternal(Comparator<F> termComparator) {
            return (left, right) -> {
                int order = Long.compare(right.count, left.count);
                if (order != 0) {
                    return order;
                }
                order = termComparator.compare(left.term, right.term);
                return order;
            };
        }
    }
    ,
    TERM_ASC{

        @Override
        <F> Comparator<Bucket<F>> toBucketComparatorInternal(Comparator<F> termComparator) {
            return (left, right) -> termComparator.compare(left.term, right.term);
        }
    }
    ,
    TERM_DESC{

        @Override
        boolean isTermOrderDescending() {
            return true;
        }

        @Override
        <F> Comparator<Bucket<F>> toBucketComparatorInternal(Comparator<F> termComparator) {
            return (left, right) -> termComparator.compare(left.term, right.term);
        }
    };


    <F> Comparator<Bucket<F>> toBucketComparator(Comparator<F> termAscendingComparator) {
        return this.toBucketComparatorInternal(this.isTermOrderDescending() ? termAscendingComparator.reversed() : termAscendingComparator);
    }

    abstract <F> Comparator<Bucket<F>> toBucketComparatorInternal(Comparator<F> var1);

    boolean isTermOrderDescending() {
        return false;
    }
}

