/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class QueryLog_$logger
implements QueryLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = QueryLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public QueryLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void executingLuceneQuery(Query luceneQuery) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executingLuceneQuery$str(), (Object)luceneQuery);
    }

    protected String executingLuceneQuery$str() {
        return "HSEARCH000274: Executing Lucene query: %s";
    }

    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: Invalid search predicate: '%1$s'. You must build the predicate from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: Invalid search sort: '%1$s'. You must build the sort from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: Invalid multi-index scope: a scope cannot span both a Lucene index and another type of index. Base scope: '%1$s', incompatible (Lucene) index: '%2$s'.";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder baseScope, LuceneIndexManager luceneIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: Invalid multi-index scope: a scope cannot span multiple Lucene backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder baseScope, LuceneIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: Unable to execute search query '%1$s': %2$s";
    }

    @Override
    public final SearchException ioExceptionOnQueryExecution(Query luceneQuery, String causeMessage, EventContext context, IOException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnQueryExecution$str(), luceneQuery, causeMessage), (Throwable)cause, context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(int totalShouldClauseNumber, int minimum) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ignoreConstraintCeiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: Invalid search projection: '%1$s'. You must build the projection from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries matching query '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(Query query, String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteAllEntriesFromIndex$str(), query, causeMessage), (Throwable)cause, context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.";
    }

    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fullTextFeaturesNotSupportedByFieldType$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresTypeName$str() {
        return "HSEARCH600075: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }

    @Override
    public final SearchException explainRequiresTypeName(Set<String> targetedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeName$str(), targetedTypeNames));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH600076: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(Set<String> targetedTypeNames, String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainUnknownDocument$str() {
        return "HSEARCH600077: Invalid document identifier: '%2$s'. No such document for type '%1$s'.";
    }

    @Override
    public final SearchException explainUnknownDocument(String typeName, String id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnknownDocument$str(), typeName, id));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort sort, Set<String> sortIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> projection, Set<String> projectionIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: Invalid search aggregation: '%1$s'. You must build the aggregation from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Duplicate aggregation definitions for key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH600114: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }

    @Override
    public final SearchException invalidSortModeAcrossNested(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeAcrossNested$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForStringField$str() {
        return "HSEARCH600115: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }

    @Override
    public final SearchException invalidSortModeForStringField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForStringField$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH600116: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForTemporalField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForTemporalField$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH600120: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH600121: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }

    @Override
    public final SearchException invalidNestedObjectPathForPredicate(SearchPredicate predicate, String nestedObjectPath, List<String> fieldPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH600122: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH600131: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(String absolutePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH600135: Implementation class differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentImplementationClassForQueryElement(Class<?> class1, Class<?> class2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentImplementationClassForQueryElement$str(), new ClassFormatter(class1), new ClassFormatter(class2)));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH600136: Field codec differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentFieldCodecForQueryElement(Object codec1, Object codec2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentFieldCodecForQueryElement$str(), codec1, codec2));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH600144: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(Object predicateDefinition1, Object predicateDefinition2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String paramNotDefined$str() {
        return "HSEARCH600150: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }

    @Override
    public final SearchException paramNotDefined(String name, String predicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.paramNotDefined$str(), name, predicateName), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String offsetLimitExceedsMaxValue$str() {
        return "HSEARCH600151: Offset + limit should be lower than Integer.MAX_VALUE, offset: '%1$s', limit: '%2$s'.";
    }

    @Override
    public final IOException offsetLimitExceedsMaxValue(int offset, Integer limit) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.offsetLimitExceedsMaxValue$str(), offset, limit));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH600152: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }

    @Override
    public final SearchException invalidContextForProjectionOnField(String absolutePath, String objectFieldAbsolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH600153: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(String absolutePath, String objectFieldAbsolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH600155: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }

    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(String typeName, Set<String> expectedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH600158: Invalid highlighter: '%1$s'. You must build the highlighter from a Lucene search scope.";
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherQueryHighlighters(SearchHighlighter highlighter) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH600159: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(SearchHighlighter highlighter, Set<String> highlighterIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, highlighterIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixDifferentHighlighterTypesAtOverrideLevel$str() {
        return "HSEARCH600160: Overriding a '%2$s' highlighter with a '%1$s' is not supported. Overriding highlighters should be of the same type as the global is if the global highlighter was configured.";
    }

    @Override
    public final SearchException cannotMixDifferentHighlighterTypesAtOverrideLevel(SearchHighlighterType override, SearchHighlighterType parent) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixDifferentHighlighterTypesAtOverrideLevel$str(), override, parent));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindHighlighterWithName$str() {
        return "HSEARCH600161: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }

    @Override
    public final SearchException cannotFindHighlighterWithName(String name, Collection<String> availableHighlighterNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindHighlighterWithName$str(), name, availableHighlighterNames));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedBoundaryScannerType$str() {
        return "HSEARCH600162: '%1$s' highlighter does not support '%2$s' boundary scanner type.";
    }

    @Override
    public final SearchException unsupportedBoundaryScannerType(String type, BoundaryScannerType boundaryScannerType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedBoundaryScannerType$str(), type, boundaryScannerType));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH600163: Named highlighters cannot use a blank string as name.";
    }

    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterNameCannotBeBlank$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH600164: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }

    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(String highlighterName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH600165: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }

    @Override
    public final SearchException highlighterTypeNotSupported(SearchHighlighterType type, String field) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterTypeNotSupported$str(), type, field));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void unifiedHighlighterNoMatchSizeWarning(Integer value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unifiedHighlighterNoMatchSizeWarning$str(), (Object)value);
    }

    protected String unifiedHighlighterNoMatchSizeWarning$str() {
        return "HSEARCH600169: Lucene's unified highlighter cannot limit the size of a fragment returned when no match is found. Instead if no match size was set to any positive integer - all text will be returned. Configured value '%1$s' will be ignored, and the fragment will not be limited. If you don't want to see this warning set the value to Integer.MAX_VALUE.";
    }

    protected String unifiedHighlighterFragmentSizeNotSupported$str() {
        return "HSEARCH600170: Lucene's unified highlighter does not support the size fragment setting. Either use a plain or fast vector highlighters, or do not set this setting.";
    }

    @Override
    public final SearchException unifiedHighlighterFragmentSizeNotSupported() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unifiedHighlighterFragmentSizeNotSupported$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH600171: Highlight projection cannot be applied within nested context of '%1$s'.";
    }

    @Override
    public final SearchException cannotHighlightInNestedContext(String currentNestingField, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH600172: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }

    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHighlightFieldFromNestedObjectStructure$str(), new Object[0]), eventContext);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH600173: '%1$s' cannot be nested in an object projection. %2$s";
    }

    @Override
    public final SearchException cannotUseProjectionInNestedContext(String projection, String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH600117: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForDistanceSort(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForDistanceSort$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorKnnMatchVectorTypeDiffersFromField$str() {
        return "HSEARCH600176: Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.";
    }

    @Override
    public final SearchException vectorKnnMatchVectorTypeDiffersFromField(String absoluteFieldPath, Class<?> expected, Class<?> actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorKnnMatchVectorTypeDiffersFromField$str(), absoluteFieldPath, new ClassFormatter(expected), new ClassFormatter(actual)));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorKnnMatchVectorDimensionDiffersFromField$str() {
        return "HSEARCH600178: Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.";
    }

    @Override
    public final SearchException vectorKnnMatchVectorDimensionDiffersFromField(String absoluteFieldPath, int expected, int actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorKnnMatchVectorDimensionDiffersFromField$str(), absoluteFieldPath, expected, actual));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queryStringParseException$str() {
        return "HSEARCH600180: An error occurred while parsing the query string '%1$s': %2$s";
    }

    @Override
    public final SearchException queryStringParseException(String query, String message, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.queryStringParseException$str(), query, message), (Throwable)cause);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterIncompatibleCardinality$str() {
        return "HSEARCH600186: A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.";
    }

    @Override
    public final SearchException highlighterIncompatibleCardinality() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterIncompatibleCardinality$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

