/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongHashSet;
import java.util.BitSet;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunction;

public class CountDistinct
implements AggregationFunction<CountDistinct> {
    private final BitSet counts = new BitSet(1024);
    private final LongHashSet hashCounts = new LongHashSet();

    @Override
    public void apply(long value) {
        if (value >= 0L && value < (long)this.counts.size()) {
            this.counts.set((int)value);
        } else {
            this.hashCounts.add(value);
        }
    }

    @Override
    public void merge(AggregationFunction<CountDistinct> sibling) {
        CountDistinct other = sibling.implementation();
        this.counts.or(other.counts);
        this.hashCounts.addAll((LongContainer)other.hashCounts);
    }

    @Override
    public Long result() {
        return (long)this.counts.cardinality() + (long)this.hashCounts.size();
    }

    @Override
    public CountDistinct implementation() {
        return this;
    }
}

