/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.DoubleAggregationFunction;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class DoubleAggregationFunctionCollector<AF extends DoubleAggregationFunction<?>>
implements Collector {
    private final LongMultiValuesSource valueSource;
    private final DoubleAggregationFunction<AF> aggregationFunction;
    private final Function<Long, Double> longToDouble;

    public DoubleAggregationFunctionCollector(LongMultiValuesSource valueSource, DoubleAggregationFunction<AF> aggregationFunction, Function<Long, Double> longToDouble) {
        this.valueSource = valueSource;
        this.aggregationFunction = aggregationFunction;
        this.longToDouble = longToDouble;
    }

    public void merge(DoubleAggregationFunctionCollector<AF> sibling) {
        this.aggregationFunction.merge(sibling.aggregationFunction);
    }

    public Double result() {
        return this.aggregationFunction.result();
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new AggregationFunctionLeafCollector(this.valueSource.getValues(context));
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public class AggregationFunctionLeafCollector
    implements LeafCollector {
        private final LongMultiValues values;

        public AggregationFunctionLeafCollector(LongMultiValues values) {
            this.values = values;
        }

        public void collect(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                while (this.values.hasNextValue()) {
                    long value = this.values.nextValue();
                    DoubleAggregationFunctionCollector.this.aggregationFunction.apply(DoubleAggregationFunctionCollector.this.longToDouble.apply(value));
                }
            }
        }

        public void setScorer(Scorable scorer) {
        }
    }
}

