/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;

public class ScrollWork<ER>
implements ReadWork<ER> {
    private final LuceneSearcher<?, ER> searcher;
    private final int offset;
    private final int limit;
    private final int totalHitCountThreshold;

    ScrollWork(LuceneSearcher<?, ER> searcher, int offset, int limit, int totalHitCountThreshold) {
        this.offset = offset;
        this.limit = limit;
        this.searcher = searcher;
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    @Override
    public ER execute(ReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = context.createSearcher();
            return this.searcher.scroll(indexSearcher, context.getIndexReaderMetadataResolver(), this.offset, this.limit, this.totalHitCountThreshold);
        }
        catch (IOException e) {
            throw QueryLog.INSTANCE.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), e.getMessage(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append(", limit=").append(this.limit).append("]");
        return sb.toString();
    }
}

