/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;

public class CountWork
implements ReadWork<Integer> {
    private final LuceneSearcher<?, ?> searcher;

    CountWork(LuceneSearcher<?, ?> searcher) {
        this.searcher = searcher;
    }

    @Override
    public Integer execute(ReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = context.createSearcher();
            return this.searcher.count(indexSearcher);
        }
        catch (IOException e) {
            throw QueryLog.INSTANCE.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), e.getMessage(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append("]");
        return sb.toString();
    }
}

