/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.model.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.backend.lucene.search.aggregation.dsl.LuceneSearchAggregationFactory;
import org.hibernate.search.backend.lucene.search.aggregation.dsl.impl.LuceneSearchAggregationFactoryImpl;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneMultiIndexSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneMultiIndexSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneSearchHighlighterFactory;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.predicate.dsl.impl.LuceneSearchPredicateFactoryImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.impl.LuceneSearchProjectionFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.sort.dsl.LuceneSearchSortFactory;
import org.hibernate.search.backend.lucene.search.sort.dsl.impl.LuceneSearchSortFactoryImpl;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.AbstractSearchIndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.search.aggregation.dsl.spi.SearchAggregationDslContext;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.highlighter.dsl.SearchHighlighterFactory;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateIndexScope;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.spi.SearchProjectionDslContext;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionIndexScope;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.SearchSortIndexScope;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public final class LuceneSearchIndexScopeImpl<SR>
extends AbstractSearchIndexScope<SR, LuceneSearchIndexScopeImpl<SR>, LuceneIndexModel, LuceneSearchIndexNodeContext, LuceneSearchIndexCompositeNodeContext>
implements LuceneSearchIndexScope<LuceneSearchIndexScopeImpl<SR>>,
LuceneSearchQueryIndexScope<SR, LuceneSearchIndexScopeImpl<SR>> {
    private final SearchBackendContext backendContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final Map<String, LuceneScopeIndexManagerContext> mappedTypeNameToIndex;
    private final LuceneSearchPredicateBuilderFactory predicateBuilderFactory;
    private final LuceneSearchSortBuilderFactory sortBuilderFactory;
    private final LuceneSearchProjectionBuilderFactory projectionBuilderFactory;
    private final LuceneSearchAggregationBuilderFactory aggregationBuilderFactory;

    public LuceneSearchIndexScopeImpl(BackendMappingContext mappingContext, Class<SR> rootScopeType, SearchBackendContext backendContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, TimingSource timingSource, Set<? extends LuceneScopeIndexManagerContext> indexManagerContexts) {
        super(mappingContext, rootScopeType, LuceneSearchIndexScopeImpl.toModels(indexManagerContexts));
        this.backendContext = backendContext;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.mappedTypeNameToIndex = new LinkedHashMap<String, LuceneScopeIndexManagerContext>();
        for (LuceneScopeIndexManagerContext luceneScopeIndexManagerContext : indexManagerContexts) {
            this.mappedTypeNameToIndex.put(luceneScopeIndexManagerContext.model().mappedTypeName(), luceneScopeIndexManagerContext);
        }
        this.predicateBuilderFactory = new LuceneSearchPredicateBuilderFactory(this);
        this.sortBuilderFactory = new LuceneSearchSortBuilderFactory(this);
        this.projectionBuilderFactory = new LuceneSearchProjectionBuilderFactory(this);
        this.aggregationBuilderFactory = new LuceneSearchAggregationBuilderFactory(this);
    }

    private LuceneSearchIndexScopeImpl(LuceneSearchIndexScopeImpl<SR> parentScope, LuceneSearchIndexCompositeNodeContext overriddenRoot) {
        super(parentScope, (SearchIndexCompositeNodeContext)overriddenRoot);
        this.backendContext = parentScope.backendContext;
        this.analysisDefinitionRegistry = parentScope.analysisDefinitionRegistry;
        this.multiTenancyStrategy = parentScope.multiTenancyStrategy;
        this.timingSource = parentScope.timingSource;
        this.mappedTypeNameToIndex = parentScope.mappedTypeNameToIndex;
        this.predicateBuilderFactory = new LuceneSearchPredicateBuilderFactory(this);
        this.sortBuilderFactory = new LuceneSearchSortBuilderFactory(this);
        this.projectionBuilderFactory = new LuceneSearchProjectionBuilderFactory(this);
        this.aggregationBuilderFactory = new LuceneSearchAggregationBuilderFactory(this);
    }

    private static Set<? extends LuceneIndexModel> toModels(Set<? extends LuceneScopeIndexManagerContext> indexManagerContexts) {
        return indexManagerContexts.stream().map(LuceneScopeIndexManagerContext::model).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected LuceneSearchIndexScopeImpl<SR> self() {
        return this;
    }

    public LuceneSearchIndexScopeImpl<SR> withRoot(String objectFieldPath) {
        return new LuceneSearchIndexScopeImpl<SR>(this, ((LuceneSearchIndexNodeContext)this.field(objectFieldPath)).toComposite());
    }

    @Override
    public LuceneSearchPredicateBuilderFactory predicateBuilders() {
        return this.predicateBuilderFactory;
    }

    @Override
    public LuceneSearchSortBuilderFactory sortBuilders() {
        return this.sortBuilderFactory;
    }

    @Override
    public LuceneSearchProjectionBuilderFactory projectionBuilders() {
        return this.projectionBuilderFactory;
    }

    @Override
    public LuceneSearchAggregationBuilderFactory aggregationBuilders() {
        return this.aggregationBuilderFactory;
    }

    @Override
    public <P> LuceneSearchQueryBuilder<P> select(BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?> loadingContextBuilder, SearchProjection<P> projection) {
        return this.backendContext.createSearchQueryBuilder(this, sessionContext, loadingContextBuilder, LuceneSearchProjection.from(this, projection));
    }

    @Override
    public LuceneSearchPredicateFactory<SR> predicateFactory() {
        return new LuceneSearchPredicateFactoryImpl(this.rootScopeType, SearchPredicateDslContext.root((SearchPredicateIndexScope)this));
    }

    @Override
    public LuceneSearchSortFactory<SR> sortFactory() {
        return new LuceneSearchSortFactoryImpl(SearchSortDslContext.root((SearchSortIndexScope)this, LuceneSearchSortFactoryImpl::new, this.predicateFactory()));
    }

    @Override
    public <R, E> LuceneSearchProjectionFactory<SR, R, E> projectionFactory() {
        return new LuceneSearchProjectionFactoryImpl(SearchProjectionDslContext.root((SearchProjectionIndexScope)this));
    }

    @Override
    public LuceneSearchAggregationFactory<SR> aggregationFactory() {
        return new LuceneSearchAggregationFactoryImpl(SearchAggregationDslContext.root((SearchAggregationIndexScope)this, this.predicateFactory()));
    }

    public SearchHighlighterFactory highlighterFactory() {
        return new LuceneSearchHighlighterFactory(this);
    }

    @Override
    public LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }

    @Override
    public Query filterOrNull(String tenantId) {
        return this.multiTenancyStrategy.filterOrNull(tenantId);
    }

    @Override
    public TimeoutManager createTimeoutManager(Long timeout, TimeUnit timeUnit, boolean exceptionOnTimeout) {
        return TimeoutManager.of((TimingSource)this.timingSource, (Long)timeout, (TimeUnit)timeUnit, (boolean)exceptionOnTimeout);
    }

    @Override
    public Collection<LuceneScopeIndexManagerContext> indexes() {
        return this.mappedTypeNameToIndex.values();
    }

    @Override
    public Map<String, ? extends LuceneSearchIndexContext> mappedTypeNameToIndex() {
        return this.mappedTypeNameToIndex;
    }

    @Override
    public boolean hasNestedDocuments() {
        for (LuceneScopeIndexManagerContext element : this.indexes()) {
            if (!element.model().hasNestedDocuments()) continue;
            return true;
        }
        return false;
    }

    protected LuceneSearchIndexCompositeNodeContext createMultiIndexSearchRootContext(List<LuceneSearchIndexCompositeNodeContext> rootForEachIndex) {
        return new LuceneMultiIndexSearchIndexCompositeNodeContext(this, null, rootForEachIndex);
    }

    protected LuceneSearchIndexNodeContext createMultiIndexSearchValueFieldContext(String absolutePath, List<LuceneSearchIndexNodeContext> fieldForEachIndex) {
        return new LuceneMultiIndexSearchIndexValueFieldContext(this, absolutePath, fieldForEachIndex);
    }

    protected LuceneSearchIndexNodeContext createMultiIndexSearchObjectFieldContext(String absolutePath, List<LuceneSearchIndexNodeContext> fieldForEachIndex) {
        return new LuceneMultiIndexSearchIndexCompositeNodeContext(this, absolutePath, fieldForEachIndex);
    }
}

