/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldTypeContext;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractNestingAwareAccumulatingValues;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.spi.HighlightProjectionBuilder;

public class LuceneFieldHighlightProjection<T>
implements LuceneSearchProjection<T> {
    private final Set<String> indexNames;
    private final Analyzer analyzer;
    private final String absoluteFieldPath;
    private final String highlighterName;
    private final String nestedDocumentPath;
    private final LuceneSearchIndexValueFieldTypeContext<?> typeContext;
    private final ProjectionCollector.Provider<String, T> collectorProvider;

    private LuceneFieldHighlightProjection(Builder builder, ProjectionCollector.Provider<String, T> collectorProvider) {
        this(builder.scope, builder.field, builder.highlighterName(), collectorProvider);
    }

    LuceneFieldHighlightProjection(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, String highlighterName, ProjectionCollector.Provider<String, T> collectorProvider) {
        this.indexNames = scope.hibernateSearchIndexNames();
        this.analyzer = field.type().searchAnalyzerOrNormalizer();
        this.absoluteFieldPath = field.absolutePath();
        this.highlighterName = highlighterName;
        this.nestedDocumentPath = field.nestedDocumentPath();
        this.typeContext = field.type();
        this.collectorProvider = collectorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + "highlighterName=" + this.highlighterName + "]";
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public LuceneSearchProjection.Extractor<?, T> request(ProjectionRequestContext context) {
        if (context.absoluteCurrentFieldPath() != null) {
            throw QueryLog.INSTANCE.cannotHighlightInNestedContext(context.absoluteCurrentFieldPath(), EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        context.checkValidField(this.absoluteFieldPath);
        LuceneAbstractSearchHighlighter highlighter = context.highlighter(this.highlighterName);
        if (!this.typeContext.highlighterTypeSupported(highlighter.type())) {
            throw QueryLog.INSTANCE.highlighterTypeNotSupported(highlighter.type(), this.absoluteFieldPath);
        }
        highlighter.request(context, this.absoluteFieldPath);
        if (!highlighter.isCompatible(this.collectorProvider)) {
            throw QueryLog.INSTANCE.highlighterIncompatibleCardinality();
        }
        return new FieldHighlightExtractor(context.absoluteCurrentNestedFieldPath(), highlighter, this.collectorProvider.get());
    }

    public static class Builder
    extends HighlightProjectionBuilder {
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexValueFieldContext<?> field;

        public Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            super(field.absolutePath());
            this.scope = scope;
            this.field = field;
        }

        protected String highlighterName() {
            return this.highlighterName;
        }

        public <V> SearchProjection<V> build(ProjectionCollector.Provider<String, V> collectorProvider) {
            return new LuceneFieldHighlightProjection<V>(this, collectorProvider);
        }
    }

    private class FieldHighlightExtractor<A>
    implements LuceneSearchProjection.Extractor<A, T> {
        private final String parentDocumentPath;
        private final LuceneAbstractSearchHighlighter highlighter;
        private final ProjectionCollector<String, String, A, T> collector;

        private FieldHighlightExtractor(String parentDocumentPath, LuceneAbstractSearchHighlighter highlighter, ProjectionCollector<String, String, A, T> collector) {
            this.parentDocumentPath = parentDocumentPath;
            this.highlighter = highlighter;
            this.collector = collector;
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            return this.highlighter.createValues(this.parentDocumentPath, LuceneFieldHighlightProjection.this.nestedDocumentPath, LuceneFieldHighlightProjection.this.absoluteFieldPath, LuceneFieldHighlightProjection.this.analyzer, context, this.collector);
        }

        @Override
        public T transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            return this.collector.finish(extractedData);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneValueFieldSearchQueryElementFactory<HighlightProjectionBuilder, F> {
        @Override
        public HighlightProjectionBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            if (field.nestedDocumentPath() != null) {
                throw QueryLog.INSTANCE.cannotHighlightFieldFromNestedObjectStructure(EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
            }
            return new Builder(scope, field);
        }
    }

    public static abstract class HighlighterValues<A, T>
    extends AbstractNestingAwareAccumulatingValues<String, A> {
        protected LeafReaderContext leafReaderContext;

        protected HighlighterValues(String parentDocumentPath, String nestedDocumentPath, TopDocsDataCollectorExecutionContext context, ProjectionCollector<String, ?, A, T> collector) {
            super(parentDocumentPath, nestedDocumentPath, collector, context);
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            super.context(context);
            this.leafReaderContext = context;
        }

        @Override
        protected A accumulate(A accumulated, int docId) throws IOException {
            return (A)this.collector.accumulateAll(accumulated, this.highlight(docId));
        }

        protected abstract List<String> highlight(int var1) throws IOException;
    }
}

