/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.time.temporal.TemporalAccessor;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneNumericFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneTextFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneDocumentValueSort;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;

public abstract class LuceneStandardFieldSort
extends AbstractLuceneDocumentValueSort {
    private LuceneStandardFieldSort(AbstractBuilder<?, ?, ?> builder) {
        super(builder);
    }

    private static class TemporalFieldBuilder<F extends TemporalAccessor, E extends Number>
    extends NumericFieldBuilder<F, E> {
        private TemporalFieldBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(codec, scope, field);
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: 
                case AVG: 
                case MEDIAN: {
                    super.mode(mode);
                    break;
                }
                case SUM: {
                    throw QueryLog.INSTANCE.invalidSortModeForTemporalField(mode, this.getEventContext());
                }
            }
        }
    }

    public static class TemporalFieldFactory<F extends TemporalAccessor, E extends Number>
    extends AbstractFactory<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        public TemporalFieldFactory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TemporalFieldBuilder((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }

    private static class TextFieldSort
    extends LuceneStandardFieldSort {
        private final Object effectiveMissingValue;

        private TextFieldSort(TextFieldBuilder<?> builder) {
            super(builder);
            this.effectiveMissingValue = builder.missingValue;
        }

        @Override
        protected LuceneFieldComparatorSource doCreateFieldComparatorSource(String nestedDocumentPath, MultiValueMode multiValueMode, Query nestedFilter) {
            return new LuceneTextFieldComparatorSource(nestedDocumentPath, this.effectiveMissingValue, multiValueMode, nestedFilter);
        }
    }

    private static class TextFieldBuilder<F>
    extends AbstractBuilder<F, String, LuceneFieldCodec<F, String>> {
        private TextFieldBuilder(LuceneFieldCodec<F, String> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field, codec, SortField.STRING_FIRST, SortField.STRING_LAST);
        }

        @Override
        protected Object mapMissingAs(String encoded) {
            return this.normalize(encoded);
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: {
                    super.mode(mode);
                    break;
                }
                default: {
                    throw QueryLog.INSTANCE.invalidSortModeForStringField(mode, this.getEventContext());
                }
            }
        }

        private BytesRef normalize(String value) {
            if (value == null) {
                return null;
            }
            Analyzer searchAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            return searchAnalyzerOrNormalizer.normalize(this.absoluteFieldPath, value);
        }

        public SearchSort build() {
            return new TextFieldSort(this);
        }
    }

    public static class TextFieldFactory<F>
    extends AbstractFactory<F, String, LuceneFieldCodec<F, String>> {
        public TextFieldFactory(LuceneFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TextFieldBuilder<F>(this.codec, scope, field);
        }
    }

    private static class NumericFieldSort<E extends Number>
    extends LuceneStandardFieldSort {
        private final LuceneNumericDomain<E> domain;
        private final E effectiveMissingValue;

        private NumericFieldSort(NumericFieldBuilder<?, E> builder) {
            super(builder);
            this.domain = ((AbstractLuceneNumericFieldCodec)builder.codec).getDomain();
            this.effectiveMissingValue = (Number)builder.getEffectiveMissingValue();
        }

        @Override
        protected LuceneFieldComparatorSource doCreateFieldComparatorSource(String nestedDocumentPath, MultiValueMode multiValueMode, Query nestedFilter) {
            return new LuceneNumericFieldComparatorSource<E>(nestedDocumentPath, this.domain, this.effectiveMissingValue, multiValueMode, nestedFilter);
        }
    }

    private static class NumericFieldBuilder<F, E extends Number>
    extends AbstractBuilder<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        private NumericFieldBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field, codec, codec.getDomain().getMinValue(), codec.getDomain().getMaxValue());
        }

        public SearchSort build() {
            return new NumericFieldSort(this);
        }
    }

    public static class NumericFieldFactory<F, E extends Number>
    extends AbstractFactory<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
        public NumericFieldFactory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public FieldSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new NumericFieldBuilder((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }

    static abstract class AbstractBuilder<F, E, C extends LuceneFieldCodec<F, E>>
    extends AbstractLuceneDocumentValueSort.AbstractBuilder
    implements FieldSortBuilder {
        protected final LuceneSearchIndexValueFieldContext<F> field;
        protected final C codec;
        private final Object sortMissingValueFirstPlaceholder;
        private final Object sortMissingValueLastPlaceholder;
        protected Object missingValue = SortMissingValue.MISSING_LAST;

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, C codec, Object sortMissingValueFirstPlaceholder, Object sortMissingValueLastPlaceholder) {
            super(scope, field);
            this.field = field;
            this.codec = codec;
            this.sortMissingValueFirstPlaceholder = sortMissingValueFirstPlaceholder;
            this.sortMissingValueLastPlaceholder = sortMissingValueLastPlaceholder;
        }

        public void missingFirst() {
            this.missingValue = SortMissingValue.MISSING_FIRST;
        }

        public void missingLast() {
            this.missingValue = SortMissingValue.MISSING_LAST;
        }

        public void missingHighest() {
            this.missingValue = SortMissingValue.MISSING_HIGHEST;
        }

        public void missingLowest() {
            this.missingValue = SortMissingValue.MISSING_LOWEST;
        }

        public void missingAs(Object value, ValueModel valueModel) {
            Object encoded = this.field.encodingContext().convertAndEncode(this.scope, this.field, this.codec, value, valueModel);
            this.missingValue = this.mapMissingAs(encoded);
        }

        protected Object mapMissingAs(E encoded) {
            return encoded;
        }

        protected final E getEffectiveMissingValue() {
            Object effectiveMissingValue = this.missingValue == SortMissingValue.MISSING_FIRST ? (this.order == SortOrder.DESC ? this.sortMissingValueLastPlaceholder : this.sortMissingValueFirstPlaceholder) : (this.missingValue == SortMissingValue.MISSING_LAST ? (this.order == SortOrder.DESC ? this.sortMissingValueFirstPlaceholder : this.sortMissingValueLastPlaceholder) : (this.missingValue == SortMissingValue.MISSING_LOWEST ? this.sortMissingValueFirstPlaceholder : (this.missingValue == SortMissingValue.MISSING_HIGHEST ? this.sortMissingValueLastPlaceholder : this.missingValue)));
            return (E)effectiveMissingValue;
        }
    }

    static abstract class AbstractFactory<F, E, C extends LuceneFieldCodec<F, E>>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<FieldSortBuilder, F, C> {
        protected AbstractFactory(C codec) {
            super(codec);
        }
    }
}

