/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexCompositeNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeCollector;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeContributor;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexRootBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexObjectField;
import org.hibernate.search.backend.lucene.logging.impl.MappingLog;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexCompositeNodeType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexObjectFieldBuilder
extends AbstractLuceneIndexCompositeNodeBuilder
implements IndexObjectFieldBuilder,
LuceneIndexNodeContributor {
    private final AbstractLuceneIndexCompositeNodeBuilder parent;
    private final String absoluteFieldPath;
    private final String relativeFieldName;
    private final TreeNodeInclusion inclusion;
    private boolean multiValued = false;
    private LuceneIndexObjectFieldReference reference;

    LuceneIndexObjectFieldBuilder(AbstractLuceneIndexCompositeNodeBuilder parent, String relativeFieldName, TreeNodeInclusion inclusion, ObjectStructure structure) {
        super(new LuceneIndexCompositeNodeType.Builder(structure));
        this.parent = parent;
        this.absoluteFieldPath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)relativeFieldName);
        this.relativeFieldName = relativeFieldName;
        this.inclusion = inclusion;
    }

    public EventContext eventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void multiValued() {
        this.multiValued = true;
    }

    public IndexObjectFieldReference toReference() {
        if (this.reference != null) {
            throw MappingLog.INSTANCE.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new LuceneIndexObjectFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(LuceneIndexNodeCollector collector, LuceneIndexCompositeNode parentNode, Map<String, LuceneIndexField> staticChildrenByNameForParent) {
        if (this.reference == null) {
            throw MappingLog.INSTANCE.incompleteFieldDefinition(this.eventContext());
        }
        TreeMap<String, LuceneIndexField> staticChildrenByName = new TreeMap<String, LuceneIndexField>();
        LuceneIndexObjectField node = new LuceneIndexObjectField(parentNode, this.relativeFieldName, this.typeBuilder.build(), this.inclusion, this.multiValued, staticChildrenByName, false);
        staticChildrenByNameForParent.put(this.relativeFieldName, node);
        collector.collect(this.absoluteFieldPath, node);
        this.reference.setSchemaNode(node);
        this.contributeChildren(node, collector, staticChildrenByName);
    }

    @Override
    public LuceneIndexRootBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

