/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.apache.lucene.index.VectorSimilarityFunction;
import org.hibernate.search.backend.lucene.logging.impl.MappingLog;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.LuceneVectorFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.search.predicate.spi.KnnPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;

abstract class AbstractLuceneVectorFieldTypeOptionsStep<S extends AbstractLuceneVectorFieldTypeOptionsStep<?, F>, F>
extends AbstractLuceneIndexFieldTypeOptionsStep<S, F>
implements LuceneVectorFieldTypeOptionsStep<S, F> {
    private static final int MAX_EF_CONSTRUCTION = 3200;
    private static final int MAX_M = 512;
    protected VectorSimilarity vectorSimilarity = VectorSimilarity.DEFAULT;
    protected Integer dimension;
    protected int efConstruction = 512;
    protected int m = 16;
    private Projectable projectable = Projectable.DEFAULT;
    private Searchable searchable = Searchable.DEFAULT;
    private F indexNullAsValue = null;

    AbstractLuceneVectorFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, Class<F> valueType) {
        super(buildContext, valueType);
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S searchable(Searchable searchable) {
        this.searchable = searchable;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S vectorSimilarity(VectorSimilarity vectorSimilarity) {
        this.vectorSimilarity = vectorSimilarity;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S efConstruction(int efConstruction) {
        if (efConstruction < 1 || efConstruction > 3200) {
            throw MappingLog.INSTANCE.vectorPropertyUnsupportedValue("efConstruction", efConstruction, 3200);
        }
        this.efConstruction = efConstruction;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S m(int m) {
        if (m < 1 || m > 512) {
            throw MappingLog.INSTANCE.vectorPropertyUnsupportedValue("m", m, 512);
        }
        this.m = m;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S dimension(int dimension) {
        if (dimension < 1 || dimension > 16000) {
            throw MappingLog.INSTANCE.vectorPropertyUnsupportedValue("dimension", dimension, 16000);
        }
        this.dimension = dimension;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S indexNullAs(F indexNullAsValue) {
        this.indexNullAsValue = indexNullAsValue;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public LuceneIndexValueFieldType<F> toIndexFieldType() {
        if (this.dimension == null) {
            throw MappingLog.INSTANCE.nullVectorDimension(this.buildContext.hints().missingVectorDimension(), this.buildContext.getEventContext());
        }
        VectorSimilarityFunction resolvedVectorSimilarity = AbstractLuceneVectorFieldTypeOptionsStep.resolveDefault(this.vectorSimilarity);
        boolean resolvedProjectable = AbstractLuceneVectorFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = AbstractLuceneVectorFieldTypeOptionsStep.resolveDefault(this.searchable);
        Indexing indexing = resolvedSearchable ? Indexing.ENABLED : Indexing.DISABLED;
        Storage storage = resolvedProjectable ? Storage.ENABLED : Storage.DISABLED;
        AbstractLuceneVectorFieldCodec<F> codec = this.createCodec(resolvedVectorSimilarity, this.dimension, storage, indexing, this.indexNullAsValue, new HibernateSearchKnnVectorsFormat(this.m, this.efConstruction));
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new LuceneExistsPredicate.DocValuesOrNormsBasedFactory());
            this.builder.queryElementFactory(PredicateTypeKeys.KNN, this.knnPredicateFactory());
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory(codec));
        }
        this.builder.multivaluable(false);
        return this.builder.build();
    }

    protected abstract AbstractLuceneValueFieldSearchQueryElementFactory<KnnPredicateBuilder, F> knnPredicateFactory();

    protected abstract AbstractLuceneVectorFieldCodec<F> createCodec(VectorSimilarityFunction var1, int var2, Storage var3, Indexing var4, F var5, HibernateSearchKnnVectorsFormat var6);

    private static VectorSimilarityFunction resolveDefault(VectorSimilarity vectorSimilarity) {
        switch (vectorSimilarity) {
            case DEFAULT: 
            case L2: {
                return VectorSimilarityFunction.EUCLIDEAN;
            }
            case DOT_PRODUCT: {
                return VectorSimilarityFunction.DOT_PRODUCT;
            }
            case COSINE: {
                return VectorSimilarityFunction.COSINE;
            }
            case MAX_INNER_PRODUCT: {
                return VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
            }
        }
        throw new AssertionFailure("Unexpected value for Similarity: " + String.valueOf(vectorSimilarity));
    }

    protected static boolean resolveDefault(Projectable projectable) {
        switch (projectable) {
            case DEFAULT: 
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
        }
        throw new AssertionFailure("Unexpected value for Projectable: " + String.valueOf(projectable));
    }

    protected static boolean resolveDefault(Searchable searchable) {
        switch (searchable) {
            case DEFAULT: 
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new AssertionFailure("Unexpected value for Searchable: " + String.valueOf(searchable));
    }
}

