/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;

public class RangeResults {
    static final RangeResults EMPTY = new RangeResults(new CollectorKey[0], new CollectorManager[0], 0);
    private final CollectorKey<?, ?>[] collectorKeys;
    private final CollectorManager<Collector, ?>[] managers;
    private final List<Collector>[][] buckets;

    RangeResults(CollectorKey<?, ?>[] collectorKeys, CollectorManager<Collector, ?>[] managers, int ranges) {
        this.collectorKeys = collectorKeys;
        this.managers = managers;
        this.buckets = new List[managers.length][];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new List[ranges];
            for (int j = 0; j < this.buckets[i].length; ++j) {
                this.buckets[i][j] = new ArrayList<Collector>();
            }
        }
    }

    void add(Collector[][] collectors) {
        for (int collectorIndex = 0; collectorIndex < collectors.length; ++collectorIndex) {
            for (int rangeIndex = 0; rangeIndex < collectors[collectorIndex].length; ++rangeIndex) {
                this.buckets[collectorIndex][rangeIndex].add(collectors[collectorIndex][rangeIndex]);
            }
        }
    }

    public List<Collector>[][] buckets() {
        return this.buckets;
    }

    public CollectorKey<?, ?>[] collectorKeys() {
        return this.collectorKeys;
    }

    public CollectorManager<Collector, ?>[] collectorManagers() {
        return this.managers;
    }
}

