/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CompensatedSum;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.DoubleAggregationFunctionCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneNestableAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.FieldMetricAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;

public abstract class AbstractLuceneMetricCompensatedSumAggregation<F, E extends Number, K>
extends AbstractLuceneNestableAggregation<K> {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    protected final AbstractLuceneNumericFieldCodec<F, E> codec;
    private final LuceneNumericDomain<E> numericDomain;
    private final ExtractedValueConverter<E, ? extends K> extractedConverter;
    protected CollectorKey<?, Long> collectorKey;
    protected CollectorKey<DoubleAggregationFunctionCollector<CompensatedSum>, Double> compensatedSumCollectorKey;

    AbstractLuceneMetricCompensatedSumAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.indexNames = builder.scope.hibernateSearchIndexNames();
        this.absoluteFieldPath = builder.field.absolutePath();
        this.codec = builder.codec;
        this.numericDomain = this.codec.getDomain();
        this.extractedConverter = builder.extractedConverter;
    }

    @Override
    public LuceneSearchAggregation.Extractor<K> request(AggregationRequestContext context) {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromField(this.absoluteFieldPath, this.createNestedDocsProvider(context));
        this.fillCollectors(source, context);
        return new LuceneNumericMetricFieldAggregationExtraction();
    }

    abstract void fillCollectors(JoiningLongMultiValuesSource var1, AggregationRequestContext var2);

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    abstract E extractEncoded(AggregationExtractContext var1, LuceneNumericDomain<E> var2);

    protected static abstract class Builder<F, E extends Number, K>
    extends AbstractLuceneNestableAggregation.AbstractBuilder<K>
    implements FieldMetricAggregationBuilder<K> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final ExtractedValueConverter<E, ? extends K> extractedConverter;

        public Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, ExtractedValueConverter<E, ? extends K> extractedConverter) {
            super(scope, field);
            this.codec = codec;
            this.extractedConverter = extractedConverter;
        }
    }

    protected static abstract class ExtractedValueConverter<E extends Number, K> {
        protected ExtractedValueConverter() {
        }

        abstract K convert(E var1, FromDocumentValueConvertContext var2);
    }

    private class LuceneNumericMetricFieldAggregationExtraction
    implements LuceneSearchAggregation.Extractor<K> {
        private LuceneNumericMetricFieldAggregationExtraction() {
        }

        @Override
        public K extract(AggregationExtractContext context) {
            Object extracted = AbstractLuceneMetricCompensatedSumAggregation.this.extractEncoded(context, AbstractLuceneMetricCompensatedSumAggregation.this.numericDomain);
            return AbstractLuceneMetricCompensatedSumAggregation.this.extractedConverter.convert(extracted, context.fromDocumentValueConvertContext());
        }
    }

    private static class DecodingExtractedValueConverter<E extends Number, F, T>
    extends ExtractedValueConverter<E, T> {
        private final ProjectionConverter<F, T> projectionConverter;
        private final AbstractLuceneNumericFieldCodec<F, E> codec;

        private DecodingExtractedValueConverter(ProjectionConverter<F, T> projectionConverter, AbstractLuceneNumericFieldCodec<F, E> codec) {
            this.projectionConverter = projectionConverter;
            this.codec = codec;
        }

        @Override
        T convert(E extracted, FromDocumentValueConvertContext context) {
            return (T)this.projectionConverter.fromDocumentValue(this.codec.decode(extracted), context);
        }
    }

    private static class RawExtractedValueConverter<E extends Number, T>
    extends ExtractedValueConverter<E, T> {
        private final ProjectionConverter<E, T> projectionConverter;

        private RawExtractedValueConverter(ProjectionConverter<E, T> projectionConverter) {
            this.projectionConverter = projectionConverter;
        }

        @Override
        T convert(E extracted, FromDocumentValueConvertContext context) {
            return (T)this.projectionConverter.fromDocumentValue(extracted, context);
        }
    }

    private static class DoubleExtractedValueConverter<E extends Number>
    extends ExtractedValueConverter<E, Double> {
        private DoubleExtractedValueConverter() {
        }

        @Override
        Double convert(E extracted, FromDocumentValueConvertContext context) {
            return ((Number)extracted).doubleValue();
        }
    }

    protected static abstract class TypeSelector<F, E extends Number>
    implements FieldMetricAggregationBuilder.TypeSelector {
        protected final AbstractLuceneNumericFieldCodec<F, E> codec;
        protected final LuceneSearchIndexScope<?> scope;
        protected final LuceneSearchIndexValueFieldContext<F> field;

        protected TypeSelector(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <T> Builder<F, ?, T> type(Class<T> expectedType, ValueModel valueModel) {
            ExtractedValueConverter extractedConverter;
            if (ValueModel.RAW.equals((Object)valueModel)) {
                if (Double.class.isAssignableFrom(expectedType)) {
                    extractedConverter = new DoubleExtractedValueConverter();
                } else {
                    ProjectionConverter projectionConverter = this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field);
                    extractedConverter = new RawExtractedValueConverter(projectionConverter);
                }
            } else {
                ProjectionConverter projectionConverter = this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field);
                extractedConverter = new DecodingExtractedValueConverter(projectionConverter, this.codec);
            }
            return this.getFtBuilder(extractedConverter);
        }

        protected abstract <T> Builder<F, ? extends Number, T> getFtBuilder(ExtractedValueConverter<E, ? extends T> var1);
    }
}

